/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import WayofTime.bloodmagic.altar.BloodAltar;
import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.api.impl.recipe.RecipeBloodAltar;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.item.ItemBloodOrb;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.item.armour.ItemSentientArmour;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import WayofTime.bloodmagic.item.sigil.ItemSigilHolding;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.routing.IMasterRoutingNode;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.tile.TileIncenseAltar;
import WayofTime.bloodmagic.tile.TileMimic;
import WayofTime.bloodmagic.tile.routing.TileFilteredRoutingNode;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.NumeralHelper;
import com.google.common.collect.Lists;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.elements.bloodmagic.ElementAltarCrafting;
import io.github.drmanganese.topaddons.elements.bloodmagic.ElementNodeFilter;
import io.github.drmanganese.topaddons.reference.EnumChip;
import io.github.drmanganese.topaddons.reference.Names;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@TOPAddon(dependency="bloodmagic")
public class AddonBloodMagic
extends AddonBlank {
    @GameRegistry.ObjectHolder(value="bloodmagic:mimic")
    public static Block MIMIC;
    @GameRegistry.ObjectHolder(value="bloodmagic:sigil_holding")
    public static Item SIGIL_HOLDING;
    @GameRegistry.ObjectHolder(value="bloodmagic:sigil_seer")
    public static Item SIGIL_SEER;
    @GameRegistry.ObjectHolder(value="bloodmagic:sigil_divination")
    public static Item SIGIL_DIVINATION;
    @GameRegistry.ObjectHolder(value="bloodmagic:blood_orb")
    public static Item BLOOD_ORB;
    private boolean requireSigil = true;
    private boolean seeMimickWithSigil = true;

    @Override
    public void updateConfigs(Configuration config) {
        this.requireSigil = config.get("bloodmagic", "requireSigil", true, "Is holding a divination sigil required to see certain information.").setLanguageKey("topaddons.config:bloodmagic_sigil").getBoolean();
        this.seeMimickWithSigil = config.get("bloodmagic", "seeMimickWithSigil", true, "Shows the player that they're looking at a mimick block when holding a seer sigil.").setLanguageKey("topaddons.config:bloodmagic_mimick_sigil").getBoolean();
    }

    @Override
    public void registerElements() {
        this.registerElement("filter_node", ElementNodeFilter::new);
        this.registerElement("altar_crafting", ElementAltarCrafting::new);
    }

    @Override
    public void addTankNames() {
        Names.tankNamesMap.put(TileAltar.class, new String[]{"Blood Altar"});
    }

    @Override
    public Map<Class<? extends ItemArmor>, EnumChip> getSpecialHelmets() {
        HashMap<Class<? extends ItemArmor>, EnumChip> map = new HashMap<Class<? extends ItemArmor>, EnumChip>();
        map.put(ItemLivingArmour.class, EnumChip.STANDARD);
        map.put(ItemSentientArmour.class, EnumChip.STANDARD);
        return map;
    }

    @Override
    public List<IBlockDisplayOverride> getBlockDisplayOverrides() {
        return Lists.newArrayList((Object[])new IBlockDisplayOverride[]{(mode, probeInfo, player, world, blockState, data) -> {
            ItemStack mimicStack;
            if (blockState.func_177230_c() == MIMIC && !(mimicStack = ((TileMimic)world.func_175625_s(data.getPos())).func_70301_a(0)).func_190926_b() && mimicStack.func_77973_b() instanceof ItemBlock) {
                if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                    probeInfo.horizontal().item(mimicStack).vertical().itemLabel(mimicStack).text(TextStyleClass.MODNAME + Tools.getModName((Block)((ItemBlock)mimicStack.func_77973_b()).func_179223_d()));
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(mimicStack).itemLabel(mimicStack);
                }
                return true;
            }
            return false;
        }});
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        ItemStack mimicStack;
        BlockPos sidePos;
        TileFilteredRoutingNode node;
        ItemStack filterStack;
        IBloodAltar altar;
        boolean holdingSeer = !this.requireSigil || this.holdingSigil(player, (ItemSigilBase)SIGIL_SEER);
        boolean holdingDivine = holdingSeer || !this.requireSigil || this.holdingSigil(player, (ItemSigilBase)SIGIL_DIVINATION);
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof IBloodAltar && holdingDivine) {
            altar = (IBloodAltar)tile;
            this.textPrefixed(probeInfo, "{*topaddons.bloodmagic:tier*}", NumeralHelper.toRoman((int)altar.getTier().toInt()), TextFormatting.RED);
            if (altar instanceof TileAltar && holdingSeer) {
                ItemStack result;
                ItemStack input = ((TileAltar)altar).func_70301_a(0);
                if (input.func_190926_b()) {
                    return;
                }
                BloodAltar bloodAltar = (BloodAltar)ReflectionHelper.getPrivateValue(TileAltar.class, (Object)((TileAltar)altar), (String[])new String[]{"bloodAltar"});
                if (input.func_77973_b() instanceof IBloodOrb) {
                    Binding binding = ((IBindable)input.func_77973_b()).getBinding(input);
                    if (binding != null) {
                        SoulNetwork network = NetworkHelper.getSoulNetwork((Binding)binding);
                        this.addAltarCraftingElement(probeInfo, input, ItemStack.field_190927_a, network.getCurrentEssence(), ((ItemBloodOrb)BLOOD_ORB).getOrb(input).getCapacity(), 0.0f, player);
                    } else {
                        probeInfo.text(TextStyleClass.WARNING + "{*topaddons.bloodmagic:unbound_orb*}");
                    }
                } else if (altar.isActive() && !(result = ((RecipeBloodAltar)ReflectionHelper.getPrivateValue(BloodAltar.class, (Object)bloodAltar, (String[])new String[]{"recipe"})).getOutput()).func_190926_b()) {
                    this.addAltarCraftingElement(probeInfo, input, result, bloodAltar.getProgress(), bloodAltar.getLiquidRequired(), bloodAltar.getConsumptionRate(), player);
                }
            }
        }
        if (tile instanceof TileFilteredRoutingNode && !(tile instanceof IMasterRoutingNode) && !(filterStack = (node = (TileFilteredRoutingNode)tile).getFilterStack(data.getSideHit())).func_190926_b() && world.func_175625_s(sidePos = data.getPos().func_177972_a(data.getSideHit())) != null) {
            IBlockState sideState = world.func_180495_p(sidePos);
            ItemStack inventoryOnSide = sideState.func_177230_c().getPickBlock(sideState, new RayTraceResult(data.getHitVec(), data.getSideHit().func_176734_d(), sidePos), world, sidePos, player);
            this.addFilterElement(probeInfo, data.getSideHit().func_176610_l(), inventoryOnSide, filterStack, player);
        }
        if (tile instanceof TileIncenseAltar && holdingDivine) {
            altar = (TileIncenseAltar)tile;
            AddonBloodMagic.textPrefixed(probeInfo, "{*topaddons.bloodmagic:tranquility*}", Integer.toString((int)(100.0 * (double)((int)(100.0 * altar.tranquility)) / 100.0)));
            AddonBloodMagic.textPrefixed(probeInfo, "{*topaddons.bloodmagic:bonus*}", (int)(altar.incenseAddition * 100.0) + "%");
        }
        if (tile instanceof TileMimic && this.seeMimickWithSigil && holdingSeer && !(mimicStack = ((TileMimic)world.func_175625_s(data.getPos())).func_70301_a(0)).func_190926_b()) {
            probeInfo.text(TextFormatting.GRAY + data.getPickBlock().func_82833_r());
        }
    }

    private boolean holdingSigil(EntityPlayer player, ItemSigilBase sigil) {
        for (EnumHand hand : EnumHand.values()) {
            ItemStack heldStack = player.func_184586_b(hand);
            if (heldStack.func_190926_b()) continue;
            if (heldStack.func_77973_b() == sigil) {
                return true;
            }
            if (heldStack.func_77973_b() != SIGIL_HOLDING) continue;
            ItemStack currentHoldingStack = ItemSigilHolding.getItemStackInSlot((ItemStack)heldStack, (int)ItemSigilHolding.getCurrentItemOrdinal((ItemStack)heldStack));
            return !currentHoldingStack.func_190926_b() && currentHoldingStack.func_77973_b() == sigil;
        }
        return false;
    }

    private void addFilterElement(IProbeInfo probeInfo, String side, ItemStack inventoryOnSide, ItemStack filterStack, EntityPlayer player) {
        probeInfo.element((IElement)new ElementNodeFilter(AddonBloodMagic.getElementId(player, "filter_node"), side, inventoryOnSide, filterStack));
    }

    private void addAltarCraftingElement(IProbeInfo probeInfo, ItemStack input, ItemStack result, int progress, int required, float consumption, EntityPlayer player) {
        probeInfo.element((IElement)new ElementAltarCrafting(AddonBloodMagic.getElementId(player, "altar_crafting"), input, result, progress, required * input.func_190916_E(), consumption));
    }
}

