/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import com.brandon3055.brandonscore.lib.TeleportUtils;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;

public class Teleporter {

    public static class TeleportLocation {
        protected double xCoord;
        protected double yCoord;
        protected double zCoord;
        protected int dimension;
        protected float pitch;
        protected float yaw;
        protected String name;
        protected String dimensionName = "";
        protected boolean writeProtected = false;

        public TeleportLocation() {
        }

        public TeleportLocation(double x, double y, double z, int dimension) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.dimension = dimension;
            this.pitch = 0.0f;
            this.yaw = 0.0f;
        }

        public TeleportLocation(double x, double y, double z, int dimension, float pitch, float yaw) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.dimension = dimension;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public TeleportLocation(double x, double y, double z, int dimension, float pitch, float yaw, String name) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.dimension = dimension;
            this.pitch = pitch;
            this.yaw = yaw;
            this.name = name;
        }

        public double getXCoord() {
            return this.xCoord;
        }

        public double getYCoord() {
            return this.yCoord;
        }

        public double getZCoord() {
            return this.zCoord;
        }

        public int getDimension() {
            return this.dimension;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getYaw() {
            return this.yaw;
        }

        public String getName() {
            return this.name;
        }

        public boolean getWriteProtected() {
            return this.writeProtected;
        }

        public void setXCoord(double x) {
            this.xCoord = x;
        }

        public void setYCoord(double y) {
            this.yCoord = y;
        }

        public void setZCoord(double z) {
            this.zCoord = z;
        }

        public void setDimension(int d) {
            this.dimension = d;
        }

        public void setPitch(float p) {
            this.pitch = p;
        }

        public void setYaw(float y) {
            this.yaw = y;
        }

        public void setName(String s) {
            this.name = s;
        }

        public void setWriteProtected(boolean b) {
            this.writeProtected = b;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74780_a("X", this.xCoord);
            compound.func_74780_a("Y", this.yCoord);
            compound.func_74780_a("Z", this.zCoord);
            compound.func_74768_a("Dimension", this.dimension);
            compound.func_74776_a("Pitch", this.pitch);
            compound.func_74776_a("Yaw", this.yaw);
            compound.func_74778_a("Name", this.name);
            compound.func_74778_a("DimentionName", this.dimensionName);
            compound.func_74757_a("WP", this.writeProtected);
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.xCoord = compound.func_74769_h("X");
            this.yCoord = compound.func_74769_h("Y");
            this.zCoord = compound.func_74769_h("Z");
            this.dimension = compound.func_74762_e("Dimension");
            this.pitch = compound.func_74760_g("Pitch");
            this.yaw = compound.func_74760_g("Yaw");
            this.name = compound.func_74779_i("Name");
            this.dimensionName = compound.func_74779_i("DimentionName");
            this.writeProtected = compound.func_74767_n("WP");
        }

        public void teleport(Entity entity) {
            TeleportUtils.teleportEntity(entity, this.dimension, this.xCoord, this.yCoord, this.zCoord, this.yaw, this.pitch);
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public int hashCode() {
            return (this.xCoord + "-" + this.yCoord + "-" + this.zCoord + "-" + this.name + "-" + this.dimensionName + "-" + this.dimension + "-" + this.yaw + "-" + this.pitch).hashCode();
        }
    }
}

