/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketTickTime
implements IMessage {
    public Map<Integer, Integer> tickTimes;
    public int overall;

    public PacketTickTime() {
    }

    public PacketTickTime(Map<Integer, Integer> dimTimes, int overall) {
        this.tickTimes = dimTimes;
        this.overall = overall;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.overall - Integer.MAX_VALUE);
        buf.writeShort(this.tickTimes.size());
        for (Integer dim : this.tickTimes.keySet()) {
            buf.writeShort(dim.intValue());
            buf.writeShort(this.tickTimes.get(dim) - Short.MAX_VALUE);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.overall = buf.readInt() + Integer.MAX_VALUE;
        this.tickTimes = new HashMap<Integer, Integer>();
        int dimCount = buf.readShort();
        for (int i = 0; i < dimCount; ++i) {
            this.tickTimes.put(Integer.valueOf(buf.readShort()), buf.readShort() + Short.MAX_VALUE);
        }
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketTickTime, IMessage> {
        @Override
        public IMessage handleMessage(PacketTickTime message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                BCClientEventHandler.handleTickPacket(message);
            }
            return null;
        }
    }
}

