/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class ManagedEnum<T extends Enum<T>>
extends AbstractManagedData {
    public T value;
    public T lastTickValue;
    public Map<Integer, T> indexToValue = new HashMap<Integer, T>();
    public Map<T, Integer> valueToIndex = new HashMap<T, Integer>();

    public ManagedEnum(T value) {
        this.lastTickValue = value;
        this.value = this.lastTickValue;
        Enum[] v = (Enum[])((Enum)value).getDeclaringClass().getEnumConstants();
        if (v.length > 255) {
            throw new RuntimeException("Max enum size supported by SyncableEnum is 255");
        }
        for (int i = 0; i < v.length; ++i) {
            this.indexToValue.put(i, v[i]);
            this.valueToIndex.put(v[i], i);
        }
    }

    @Override
    public boolean detectChanges() {
        if (this.value != this.lastTickValue) {
            this.lastTickValue = this.value;
            return true;
        }
        return false;
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeByte((int)this.valueToIndex.get(this.value).byteValue());
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = (Enum)this.indexToValue.get(input.readByte() & 0xFF);
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74774_a(this.name, this.valueToIndex.get(this.value).byteValue());
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        this.value = (Enum)this.indexToValue.get(compound.func_74771_c(this.name) & 0xFF);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

