/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class ScissorHelper {
    private static LinkedList<ScissorState> prevStates = new LinkedList();
    private static ScissorState currentState = null;

    public static void pushGuiScissor(Minecraft mc, double x, double y, double width, double height, int screenWidth, int screenHeight) {
        double yResScale = (double)mc.field_71440_d / (double)screenHeight;
        double xResScale = (double)mc.field_71443_c / (double)screenWidth;
        double scaledWidth = width * xResScale;
        double scaledHeight = height * yResScale;
        int screenX = (int)(x * xResScale);
        int screenY = (int)((double)mc.field_71440_d - y * yResScale - scaledHeight);
        ScissorHelper.pushScissor(mc, screenX, screenY, (int)scaledWidth, (int)scaledHeight);
    }

    public static void pushScissor(int x, int y, int width, int height) {
        ScissorHelper.pushScissor(Minecraft.func_71410_x(), x, y, width, height);
    }

    public static void pushScissor(Minecraft mc, int x, int y, int width, int height) {
        int xMax = x + width;
        int yMax = y + height;
        if (currentState == null) {
            currentState = new ScissorState(false, 0, 0, mc.field_71443_c, mc.field_71440_d);
            prevStates.add(currentState);
        } else {
            prevStates.add(currentState);
        }
        currentState = new ScissorState(true, x, y, xMax, yMax, ScissorHelper.currentState).apply();
    }

    public static void popScissor() {
        ScissorState lastState;
        ScissorState scissorState = lastState = prevStates.size() > 0 ? prevStates.removeLast() : null;
        if (lastState != null) {
            currentState = lastState.apply();
            if (!currentState.enabled) {
                currentState = null;
            }
        } else {
            LogHelperBC.bigError("ScissorHelper: Attempt to popScissor but Scissor state has not been set", new Object[0]);
        }
    }

    private static class ScissorState {
        private boolean enabled;
        private int x;
        private int y;
        private int xMax;
        private int yMax;

        private ScissorState(boolean enabled, int x, int y, int xMax, int yMax, ScissorState prevState) {
            this.enabled = enabled;
            this.x = Math.max(prevState.x, x);
            this.y = Math.max(prevState.y, y);
            this.xMax = Math.min(prevState.xMax, xMax);
            this.yMax = Math.min(prevState.yMax, yMax);
            Minecraft mc = Minecraft.func_71410_x();
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.xMax > mc.field_71443_c) {
                this.xMax = mc.field_71443_c;
            }
            if (this.yMax > mc.field_71440_d) {
                this.yMax = mc.field_71440_d;
            }
            if (this.xMax < this.x) {
                this.xMax = this.x;
            }
            if (this.yMax < this.y) {
                this.yMax = this.y;
            }
        }

        private ScissorState(boolean enabled, int x, int y, int xMax, int yMax) {
            this.enabled = enabled;
            this.x = x;
            this.y = y;
            this.xMax = xMax;
            this.yMax = yMax;
        }

        private ScissorState apply() {
            if (this.enabled) {
                GL11.glEnable((int)3089);
            } else {
                GL11.glDisable((int)3089);
            }
            GL11.glScissor((int)this.x, (int)this.y, (int)(this.xMax - this.x), (int)(this.yMax - this.y));
            return this;
        }
    }
}

