/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.particle;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.particle.BCEffectRenderer;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IBCParticleFactory;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.network.PacketSpawnParticle;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BCEffectHandler {
    private static BCEffectHandler instance = new BCEffectHandler();
    @SideOnly(value=Side.CLIENT)
    public static BCEffectRenderer effectRenderer;
    public static Map<Integer, PairKV<IBCParticleFactory, ResourceLocation>> particleRegistry;
    private static int lastIndex;
    private static World currentWorld;
    private static final IGLFXHandler RAW_GL_DUMMY_HANDLER;

    @SideOnly(value=Side.CLIENT)
    public static void iniEffectRenderer() {
        effectRenderer = new BCEffectRenderer(null);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SideOnly(value=Side.CLIENT)
    public static int registerFX(ResourceLocation particleSheet, IBCParticleFactory factory) {
        particleRegistry.put(++lastIndex, new PairKV<IBCParticleFactory, ResourceLocation>(factory, particleSheet));
        return lastIndex;
    }

    public static int registerFXServer() {
        return ++lastIndex;
    }

    public static void spawnFX(int particleID, World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, double viewRange, int ... args) {
        BCEffectHandler.spawnFX(particleID, world, new Vec3D(xCoord, yCoord, zCoord), new Vec3D(xSpeed, ySpeed, zSpeed), viewRange, args);
    }

    public static void spawnFX(int particleID, World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... args) {
        BCEffectHandler.spawnFX(particleID, world, new Vec3D(xCoord, yCoord, zCoord), new Vec3D(xSpeed, ySpeed, zSpeed), 32.0, args);
    }

    public static void spawnFX(int particleID, World world, Vec3D pos, Vec3D speed, int ... args) {
        BCEffectHandler.spawnFX(particleID, world, pos, speed, 32.0, args);
    }

    public static void spawnFX(int particleID, World world, Vec3D pos, Vec3D speed, double viewRange, int ... args) {
        if (!world.field_72995_K) {
            BrandonsCore.network.sendToAllAround((IMessage)new PacketSpawnParticle(particleID, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z, viewRange, args), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), pos.x, pos.y, pos.z, viewRange));
        } else if (BCEffectHandler.isInRange(pos.x, pos.y, pos.z, viewRange) && effectRenderer != null) {
            if (!particleRegistry.containsKey(particleID)) {
                LogHelperBC.error("Attempted to spawn an unregistered particle ID (%s)", particleID);
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (particleSetting == 2 || particleSetting == 1 && world.field_73012_v.nextInt(3) != 0) {
                return;
            }
            PairKV<IBCParticleFactory, ResourceLocation> pair = particleRegistry.get(particleID);
            Particle particle = pair.getKey().getEntityFX(particleID, world, pos, speed, args);
            if (particle instanceof BCParticle && ((BCParticle)particle).isRawGLParticle()) {
                effectRenderer.addRawGLEffect(RAW_GL_DUMMY_HANDLER, (BCParticle)particle);
            } else {
                effectRenderer.addEffect(pair.getValue(), particle);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnFXDirect(ResourceLocation texture, BCParticle particle) {
        BCEffectHandler.spawnFXDirect(texture, particle, 32.0, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnFXDirect(ResourceLocation texture, BCParticle particle, double viewRange, boolean respectParticleSetting) {
        Vec3D pos = particle.getPos();
        if (BCEffectHandler.isInRange(pos.x, pos.y, pos.z, viewRange) && effectRenderer != null) {
            Minecraft mc = Minecraft.func_71410_x();
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (respectParticleSetting && (particleSetting == 2 || particleSetting == 1 && particle.getWorld().field_73012_v.nextInt(3) != 0)) {
                return;
            }
            effectRenderer.addEffect(texture, particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnGLParticle(IGLFXHandler handler, BCParticle particle, double viewRange, boolean respectParticleSetting) {
        Vec3D pos = particle.getPos();
        if (BCEffectHandler.isInRange(pos.x, pos.y, pos.z, viewRange) && effectRenderer != null) {
            Minecraft mc = Minecraft.func_71410_x();
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (respectParticleSetting && (particleSetting == 2 || particleSetting == 1 && particle.getWorld().field_73012_v.nextInt(3) != 0)) {
                return;
            }
            effectRenderer.addRawGLEffect(handler, particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnGLParticle(IGLFXHandler handler, BCParticle particle) {
        effectRenderer.addRawGLEffect(handler, particle);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase != TickEvent.Phase.END || mc.func_147113_T()) {
            return;
        }
        if (currentWorld != mc.field_71441_e && mc.field_71441_e != null) {
            currentWorld = mc.field_71441_e;
            BrandonsCore.proxy.resetEffectRenderer(currentWorld);
        }
        if (BCEffectHandler.effectRenderer.world != null) {
            BCProfiler.TICK.start("update_bc_effect_renderer");
            mc.field_71424_I.func_76320_a("BCParticlesUpdate");
            effectRenderer.updateEffects();
            mc.field_71424_I.func_76319_b();
            BCProfiler.TICK.stop();
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        BrandonsCore.proxy.resetEffectRenderer(event.getWorld());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderWorld(RenderWorldLastEvent event) {
        BCProfiler.RENDER.start("bc_effect_renderer_draw");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("BCParticles");
        effectRenderer.renderParticles((Entity)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks());
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        BCProfiler.RENDER.stop();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void debugOverlay(RenderGameOverlayEvent.Text event) {
        if (event.getLeft().size() >= 5 && effectRenderer != null) {
            String particleTxt = (String)event.getLeft().get(4);
            particleTxt = particleTxt + "." + TextFormatting.GOLD + " BC-P: " + effectRenderer.getStatistics();
            event.getLeft().set(4, particleTxt);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isInRange(double x, double y, double z, double vewRange) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.func_175606_aa() == null || mc.field_71452_i == null) {
            return false;
        }
        double var15 = mc.func_175606_aa().field_70165_t - x;
        double var17 = mc.func_175606_aa().field_70163_u - y;
        double var19 = mc.func_175606_aa().field_70161_v - z;
        return !(var15 * var15 + var17 * var17 + var19 * var19 > vewRange * vewRange);
    }

    static {
        particleRegistry = new LinkedHashMap<Integer, PairKV<IBCParticleFactory, ResourceLocation>>();
        lastIndex = -1;
        currentWorld = null;
        RAW_GL_DUMMY_HANDLER = new IGLFXHandler(){

            @Override
            public void preDraw(int layer, BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            }

            @Override
            public void postDraw(int layer, BufferBuilder buffer, Tessellator tessellator) {
            }
        };
    }
}

