/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements;

import com.brandon3055.brandonscore.client.gui.modulargui_old.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IScrollListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiListEntry;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiScrollBar;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class MGuiList
extends MGuiElementBase
implements IScrollListener {
    protected boolean scrollBarEnabled = true;
    protected MGuiScrollBar scrollBar;
    public int leftPadding = 1;
    public int rightPadding = 1;
    public int topPadding = 1;
    public int bottomPadding = 1;
    public boolean disableList = false;
    protected boolean updateRequired = true;
    public boolean allowOutsideClicks = false;
    public boolean lockScrollBar = false;
    public LinkedList<MGuiListEntry> listEntries = new LinkedList();
    public LinkedList<MGuiElementBase> nonListEntries = new LinkedList();
    private boolean scrollingEnabled = true;

    public MGuiList(IModularGui modularGui) {
        super(modularGui);
    }

    public MGuiList(IModularGui modularGui, int xPos, int yPos) {
        super(modularGui, xPos, yPos);
    }

    public MGuiList(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize) {
        super(modularGui, xPos, yPos, xSize, ySize);
    }

    @Override
    public void initElement() {
        this.initScrollBar();
        this.updateEntriesAndScrollBar();
        super.initElement();
    }

    protected void initScrollBar() {
        if (this.scrollBar != null) {
            this.removeChild(this.scrollBar);
        }
        if (!this.scrollingEnabled) {
            return;
        }
        this.scrollBar = new MGuiScrollBar(this.modularGui, this.xPos + this.xSize - 10, this.yPos + 1, 10, this.ySize - 2);
        this.addChild(this.scrollBar);
        this.scrollBar.setListener(this);
        this.scrollBar.parentScrollable = this;
    }

    public MGuiList addEntry(MGuiListEntry entry) {
        this.listEntries.add(entry);
        entry.setList(this);
        super.addChild(entry);
        this.updateRequired = true;
        return this;
    }

    @Override
    public MGuiElementBase addChild(MGuiElementBase element) {
        this.nonListEntries.add(element);
        return super.addChild(element);
    }

    public void clear() {
        this.toRemove.addAll(this.listEntries);
        this.listEntries.clear();
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase element : this.nonListEntries) {
            if (!element.isEnabled() || this.listEntries.contains(element)) continue;
            element.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
        if (this.disableList) {
            return;
        }
        GL11.glEnable((int)3089);
        int xPos = this.xPos + this.leftPadding;
        int yPos = this.yPos + this.topPadding;
        int xSize = this.xSize - this.leftPadding - this.rightPadding;
        int ySize = this.ySize - this.topPadding - this.bottomPadding;
        double hs = (double)minecraft.field_71440_d / (double)this.modularGui.screenHeight();
        double ws = (double)minecraft.field_71443_c / (double)this.modularGui.screenWidth();
        int sx = (int)((double)xSize * ws);
        int sy = (int)((double)ySize * hs);
        GL11.glScissor((int)((int)((double)xPos * ws)), (int)(minecraft.field_71440_d - (int)((double)yPos * hs) - sy), (int)sx, (int)sy);
        for (MGuiElementBase mGuiElementBase : this.listEntries) {
            if (!mGuiElementBase.isEnabled()) continue;
            mGuiElementBase.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
        GL11.glScissor((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GL11.glDisable((int)3089);
    }

    @Override
    public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase element : this.nonListEntries) {
            if (!element.isEnabled() || this.listEntries.contains(element)) continue;
            element.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
        if (this.disableList) {
            return;
        }
        GL11.glEnable((int)3089);
        int xPos = this.xPos + this.leftPadding;
        int yPos = this.yPos + this.topPadding;
        int xSize = this.xSize - this.leftPadding - this.rightPadding;
        int ySize = this.ySize - this.topPadding - this.bottomPadding;
        double hs = (double)minecraft.field_71440_d / (double)this.modularGui.screenHeight();
        double ws = (double)minecraft.field_71443_c / (double)this.modularGui.screenWidth();
        int sx = (int)((double)xSize * ws);
        int sy = (int)((double)ySize * hs);
        GL11.glScissor((int)((int)((double)xPos * ws)), (int)(minecraft.field_71440_d - (int)((double)yPos * hs) - sy), (int)sx, (int)sy);
        for (MGuiElementBase mGuiElementBase : this.listEntries) {
            if (!mGuiElementBase.isEnabled()) continue;
            mGuiElementBase.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
        GL11.glScissor((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GL11.glDisable((int)3089);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase mGuiElementBase : this.nonListEntries) {
            if (!mGuiElementBase.isEnabled() || this.listEntries.contains(mGuiElementBase) || !mGuiElementBase.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks)) continue;
            return true;
        }
        if (this.disableList) {
            return false;
        }
        for (MGuiElementBase mGuiElementBase : this.listEntries) {
            if (!mGuiElementBase.isEnabled() || !mGuiElementBase.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks)) continue;
            return true;
        }
        return false;
    }

    protected void cullList() {
    }

    @Override
    public void scrollBarMoved(double pos) {
        if (!this.scrollingEnabled) {
            return;
        }
        if (this.scrollBar == null) {
            this.initScrollBar();
        }
        int maxMove = this.getListHeight() - (this.ySize - 1);
        this.scrollBar.setIncrements(50.0 / (double)maxMove, 0.1);
        this.updateEntriesAndScrollBar();
    }

    protected void updateEntriesAndScrollBar() {
        boolean canScroll;
        if (!this.scrollingEnabled) {
            return;
        }
        if (this.scrollBar == null) {
            this.initScrollBar();
        }
        double scrollPos = this.scrollBar == null ? 0.0 : this.scrollBar.getScrollPos();
        int yOffset = this.topPadding;
        int maxMove = this.getListHeight() - (this.ySize - 1);
        if (maxMove > 0 && scrollPos > 0.0) {
            yOffset = this.topPadding - (int)(scrollPos * (double)maxMove);
        }
        for (MGuiListEntry entry : this.listEntries) {
            if (!entry.isEnabled()) continue;
            entry.moveEntry(this.xPos + this.leftPadding, this.yPos + yOffset);
            yOffset += entry.getEntryHeight();
        }
        boolean bl = canScroll = maxMove > 0;
        if (!canScroll && this.lockScrollBar) {
            this.scrollBarEnabled = true;
            this.scrollBar.setEnabled(true);
            this.scrollBar.setBarSizeRatio(0.0);
        } else {
            this.scrollBarEnabled = canScroll;
            this.scrollBar.setEnabled(this.scrollBarEnabled);
            this.scrollBar.setBarSizeRatio((double)(maxMove + this.ySize) / (double)this.ySize);
        }
    }

    protected int getListHeight() {
        int height = 0;
        for (MGuiListEntry entry : this.listEntries) {
            if (!entry.isEnabled()) continue;
            height += entry.getEntryHeight();
        }
        return height + this.topPadding + this.bottomPadding;
    }

    protected int getRawListHeight() {
        int height = 0;
        for (MGuiListEntry entry : this.listEntries) {
            if (!entry.isEnabled()) continue;
            height += entry.getEntryHeight();
        }
        return height;
    }

    @Override
    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        return super.handleMouseScroll(mouseX, mouseY, scrollDirection);
    }

    @Override
    public boolean onUpdate() {
        if (!this.toRemove.isEmpty()) {
            this.nonListEntries.removeAll(this.toRemove);
        }
        if (this.updateRequired) {
            this.updateRequired = false;
            this.updateEntriesAndScrollBar();
        }
        return super.onUpdate();
    }

    public void schedualUpdate() {
        this.updateRequired = true;
    }

    public MGuiList setScrollBarEnabled(boolean scrollBarEnabled) {
        this.scrollBarEnabled = scrollBarEnabled;
        return this;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isMouseOver(mouseX, mouseY) && !this.allowOutsideClicks) {
            return false;
        }
        for (MGuiElementBase mGuiElementBase : this.nonListEntries) {
            if (!mGuiElementBase.isEnabled() || !mGuiElementBase.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        if (this.disableList) {
            return false;
        }
        for (MGuiElementBase mGuiElementBase : this.listEntries) {
            if (!mGuiElementBase.isEnabled() || !mGuiElementBase.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    public MGuiList setScrollingEnabled(boolean scrollingEnabled) {
        this.scrollingEnabled = scrollingEnabled;
        return this;
    }

    public MGuiList sortEvenSpacing(boolean compress) {
        int totalEntryHeight = this.getRawListHeight();
        int remainingSpace = this.ySize - totalEntryHeight;
        double y = this.yPos;
        if (remainingSpace >= 0) {
            for (MGuiListEntry entry : this.listEntries) {
                entry.setXPos(this.xPos + (this.xSize - entry.xSize) / 2);
                entry.setYPos((int)y);
                y += (double)entry.ySize;
            }
            y = 0.0;
            for (MGuiListEntry entry : this.listEntries) {
                double eHeight = entry.getEntryHeight();
                double scale = eHeight / (double)totalEntryHeight;
                double offsetShare = scale * (double)remainingSpace / 2.0;
                entry.moveBy(0, (int)(y + offsetShare));
                y += offsetShare * 2.0;
            }
        } else {
            int ySize = compress ? this.ySize : totalEntryHeight;
            int i = 0;
            for (MGuiListEntry entry : this.listEntries) {
                double eHeight = entry.getEntryHeight();
                double yAllocation = (double)ySize / (double)this.listEntries.size();
                double overlap = eHeight - yAllocation;
                yAllocation = ((double)ySize - overlap) / (double)this.listEntries.size();
                entry.setXPos(this.xPos + (this.xSize - entry.xSize) / 2);
                entry.setYPos(this.yPos + (int)((double)i * yAllocation));
                ++i;
            }
        }
        return this;
    }
}

