/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property;

import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.HAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.VAlign;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PropertyVisitor {
    public Map<String, String> invalidCalls = new HashMap<String, String>();
    public static final String NOT_SUPPORTED = "Not supported by this tag";

    public void startVisit() {
    }

    public void visitSize(int size, boolean screenRelative) {
        this.invalidCalls.put("size", NOT_SUPPORTED);
    }

    public void visitWidth(int width, boolean screenRelative) {
        this.invalidCalls.put("width", NOT_SUPPORTED);
    }

    public void visitHeight(int height) {
        this.invalidCalls.put("height", NOT_SUPPORTED);
    }

    public void visitTooltip(List<String> tooltip) {
        this.invalidCalls.put("tooltip", NOT_SUPPORTED);
    }

    public void visitEnabledTooltip(boolean enableTooltip) {
        this.invalidCalls.put("enable_tooltip", NOT_SUPPORTED);
    }

    public void visitAlignment(HAlign alignment) {
        this.invalidCalls.put("align", NOT_SUPPORTED);
    }

    public void visitVertAlign(VAlign vertAlignment) {
        this.invalidCalls.put("vert_align", NOT_SUPPORTED);
    }

    public void visitColour(int argb) {
        this.invalidCalls.put("colour", NOT_SUPPORTED);
    }

    public void visitColourHover(int argb) {
        this.invalidCalls.put("colour_hover", NOT_SUPPORTED);
    }

    public void visitBorderColour(int argb) {
        this.invalidCalls.put("border_colour", NOT_SUPPORTED);
    }

    public void visitBorderColourHover(int argb) {
        this.invalidCalls.put("border_colour_hover", NOT_SUPPORTED);
    }

    public void visitLeftPad(int leftPadding) {
        this.invalidCalls.put("left_pad", NOT_SUPPORTED);
    }

    public void visitRightPad(int rightPadding) {
        this.invalidCalls.put("right_pad", NOT_SUPPORTED);
    }

    public void visitTopPad(int topPadding) {
        this.invalidCalls.put("top_pad", NOT_SUPPORTED);
    }

    public void visitBottomPad(int bottomPadding) {
        this.invalidCalls.put("bottom_pad", NOT_SUPPORTED);
    }

    public void visitPadding(int padding) {
        this.visitLeftPad(padding);
        this.visitRightPad(padding);
        this.visitTopPad(padding);
        this.visitBottomPad(padding);
    }

    public final void visitInvalid(String property, String reason) {
        this.invalidCalls.put(property, reason);
    }

    public void endVisit() {
    }
}

