/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GuiEntityRenderer
extends MGuiElementBase<GuiEntityRenderer> {
    private static Map<ResourceLocation, Entity> entityCache = new HashMap<ResourceLocation, Entity>();
    private static List<ResourceLocation> invalidEntities = new ArrayList<ResourceLocation>();
    private float rotationSpeed = 1.0f;
    private float lockedRotation = 0.0f;
    private Entity entity;
    private ResourceLocation entityName;
    private boolean invalidEntity = false;
    private boolean rotationLocked = false;
    private boolean trackMouse = false;
    private boolean drawName = false;
    public boolean silentErrors = false;
    public boolean force2dSize = false;

    public GuiEntityRenderer() {
    }

    public GuiEntityRenderer(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiEntityRenderer(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    public GuiEntityRenderer setEntity(Entity entity) {
        this.entity = entity;
        if (this.entity == null) {
            if (!this.silentErrors) {
                LogHelperBC.dev("GuiEntityRenderer#setEntity: Invalid Entity - " + this.entityName);
            }
            this.invalidEntity = true;
            return this;
        }
        this.entityName = EntityList.func_191301_a((Entity)entity);
        this.invalidEntity = false;
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setEntity(ResourceLocation entity) {
        this.entityName = entity;
        this.entity = entityCache.computeIfAbsent(entity, resourceLocation -> EntityList.func_188429_b((ResourceLocation)entity, (World)this.mc.field_71441_e));
        this.invalidEntity = false;
        if (this.entity == null) {
            if (!this.silentErrors) {
                LogHelperBC.dev("GuiEntityRenderer#setEntity: Invalid Entity - " + this.entityName);
            }
            this.invalidEntity = true;
        }
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setSilentErrors(boolean silentErrors) {
        this.silentErrors = silentErrors;
        return this;
    }

    public GuiEntityRenderer setForce2dSize(boolean force2dSize) {
        this.force2dSize = force2dSize;
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.invalidEntity && !this.silentErrors) {
            LogHelperBC.dev("GuiEntityRenderer: Invalid Entity - " + this.entityName);
            return;
        }
        try {
            if (this.entity != null) {
                float rotation;
                Rectangle rect = this.getInsetRect();
                float scale = this.force2dSize ? Math.min((float)rect.height / this.entity.field_70131_O, (float)rect.width / this.entity.field_70130_N) : (float)rect.height / this.entity.field_70131_O;
                double zLevel = this.getRenderZLevel() + 100.0;
                double posX = (double)rect.x + (double)rect.width / 2.0;
                float f = rotation = this.isRotationLocked() ? this.getLockedRotation() : ((float)BCClientEventHandler.elapsedTicks + partialTicks) * this.getRotationSpeedMultiplier();
                if (this.entity instanceof EntityLivingBase) {
                    int eyeOffset = (int)((this.entity.field_70131_O - this.entity.func_70047_e()) * scale);
                    GuiEntityRenderer.drawEntityOnScreen(posX, rect.y, scale, (int)posX - mouseX, rect.y - mouseY + eyeOffset, (EntityLivingBase)this.entity, this.trackMouse, rotation, this.drawName, zLevel);
                } else {
                    GuiEntityRenderer.drawEntityOnScreen(posX, rect.y, scale, this.entity, rotation, zLevel);
                }
            }
        }
        catch (Throwable e) {
            this.invalidEntity = true;
            invalidEntities.add(this.entityName);
            LogHelperBC.error("Failed to build entity in GUI. This is not a bug there are just some entities that can not be rendered like this.");
            LogHelperBC.error("Entity: " + this.entity);
            e.printStackTrace();
        }
    }

    public boolean isRotationLocked() {
        return this.rotationLocked;
    }

    public GuiEntityRenderer rotationLocked(boolean rotationLocked) {
        this.rotationLocked = rotationLocked;
        return this;
    }

    public GuiEntityRenderer setLockedRotation(float lockedRotation) {
        this.lockedRotation = lockedRotation;
        this.rotationLocked(true);
        return this;
    }

    public float getLockedRotation() {
        return this.lockedRotation;
    }

    public boolean isInvalidEntity() {
        return this.invalidEntity;
    }

    public GuiEntityRenderer setRotationSpeedMultiplier(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public GuiEntityRenderer setTrackMouse(boolean trackMouse) {
        this.trackMouse = trackMouse;
        return this;
    }

    public GuiEntityRenderer setDrawName(boolean drawName) {
        this.drawName = drawName;
        return this;
    }

    public float getRotationSpeedMultiplier() {
        return this.rotationSpeed;
    }

    public static void drawEntityOnScreen(double posX, double posY, double scale, Entity ent, double rotation, double zOffset) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((float)posX), (double)((double)((float)posY) + (double)ent.field_70131_O * scale), (double)zOffset);
        GlStateManager.func_179152_a((float)((float)(-scale)), (float)((float)scale), (float)((float)scale));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        GlStateManager.func_179114_b((float)(135.0f + (float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a(ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void drawEntityOnScreen(double posX, double posY, double scale, double mouseX, double mouseY, EntityLivingBase ent, boolean trackMouse, double noTrackRotation, boolean drawName, double zOffset) {
        float rotation;
        float f = rotation = trackMouse ? 0.0f : (float)noTrackRotation;
        if (!trackMouse) {
            mouseX = 0.0;
            mouseY = 0.0;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((float)posX), (double)((double)((float)posY) + (double)ent.field_70131_O * scale), (double)zOffset);
        GlStateManager.func_179152_a((float)((float)(-scale)), (float)((float)scale), (float)((float)scale));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f22 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)(135.0f + rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f + rotation + (float)(drawName ? 0 : 180));
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f2;
        ent.field_70177_z = f1;
        ent.field_70125_A = f22;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static EntityPlayer createRenderPlayer(World world, String username) {
        return new EntityOtherPlayerMP(world, TileEntitySkull.func_174884_b((GameProfile)new GameProfile(null, username))){

            public String func_175154_l() {
                return super.func_175154_l();
            }

            public ResourceLocation func_110306_p() {
                ResourceLocation resourcelocation;
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(this.func_146103_bH());
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    UUID uuid = EntityPlayer.func_146094_a((GameProfile)this.func_146103_bH());
                    resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                }
                return resourcelocation;
            }

            public boolean func_175148_a(EnumPlayerModelParts part) {
                return true;
            }
        };
    }

    @Override
    public boolean onUpdate() {
        return super.onUpdate();
    }
}

