/*
 * Decompiled with CFR 0.152.
 */
package com.animania.manual.gui;

import com.animania.Animania;
import com.animania.manual.components.IManualComponent;
import com.animania.manual.groups.ManualPage;
import com.animania.manual.groups.ManualTopic;
import com.animania.manual.resources.ManualResourceLoader;
import com.animania.network.common.PacketCloseManual;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class GuiManual
extends GuiScreen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("animania", "textures/gui/book.png");
    public static final int START_OFFSET_X = 36;
    public static final int START_OFFSET_Y = 16;
    public static final int LINE_Y_OFFSET = 1;
    public static final int LINE_X_OFFSET = Minecraft.func_71410_x().field_71466_p.func_78256_a(" ");
    public static final int MANUAL_MAX_X = 114;
    public static final int MANUAL_MAX_Y = 154;
    public int guiLeft;
    public int guiTop;
    public int xSize = 186;
    public int ySize = 201;
    public int x;
    public int y;
    public ManualTopic currentTopic = ManualResourceLoader.firstTopic;
    public ManualTopic lastTopic = ManualResourceLoader.firstTopic;
    private ManualPage currentPage;
    public boolean isPrevTopic = false;
    public Map<ResourceLocation, ManualTopic> manualContent = new HashMap<ResourceLocation, ManualTopic>();
    public static GuiManual INSTANCE = new GuiManual();
    public int pageIndex = 0;
    private GuiButton buttonNextPage;
    private GuiButton buttonPreviousPage;
    private GuiButton buttonPrevTopic;
    private GuiButton buttonThisTopic;

    private GuiManual() {
    }

    public static GuiManual getInstance(ItemStack book) {
        if (book.func_77942_o()) {
            NBTTagCompound tag = book.func_77978_p();
            if (tag.func_74764_b("currentTopic") && tag.func_74764_b("lastTopic")) {
                GuiManual.INSTANCE.currentTopic = GuiManual.INSTANCE.manualContent.get(new ResourceLocation(tag.func_74779_i("currentTopic")));
                GuiManual.INSTANCE.lastTopic = GuiManual.INSTANCE.manualContent.get(new ResourceLocation(tag.func_74779_i("lastTopic")));
                if (GuiManual.INSTANCE.currentTopic == null) {
                    GuiManual.INSTANCE.currentTopic = ManualResourceLoader.firstTopic;
                }
                if (GuiManual.INSTANCE.lastTopic == null) {
                    GuiManual.INSTANCE.lastTopic = ManualResourceLoader.firstTopic;
                }
            } else {
                GuiManual.INSTANCE.currentTopic = ManualResourceLoader.firstTopic;
                GuiManual.INSTANCE.lastTopic = ManualResourceLoader.firstTopic;
            }
        } else {
            GuiManual.INSTANCE.currentTopic = ManualResourceLoader.firstTopic;
            GuiManual.INSTANCE.lastTopic = ManualResourceLoader.firstTopic;
        }
        return INSTANCE;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        Animania.network.sendToServer((IMessage)new PacketCloseManual(this.currentTopic.getId().toString(), this.lastTopic.getId().toString()));
    }

    public void func_73866_w_() {
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        this.field_146294_l = res.func_78326_a();
        this.field_146295_m = res.func_78328_b();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.x = this.guiLeft + 36;
        this.y = this.guiTop + 16;
        int i = (this.field_146294_l - 192) / 2;
        this.buttonNextPage = this.func_189646_b(new NextPageButton(0, this.guiLeft + 155, this.guiTop + 164, true));
        this.buttonPreviousPage = this.func_189646_b(new NextPageButton(1, this.guiLeft + 7, this.guiTop + 164, false));
        this.buttonPrevTopic = this.func_189646_b(new PrevPageButton(2, this.guiLeft + 9, this.guiTop + 178, false));
        this.buttonThisTopic = this.func_189646_b(new PrevPageButton(3, this.guiLeft + 159, this.guiTop + 178, true));
        this.updateButtons();
        this.initComponents();
    }

    public void initComponents() {
        ManualPage p;
        this.currentPage = p = this.pageIndex >= this.currentTopic.getPages().size() ? this.currentTopic.getPages().get(0) : this.currentTopic.getPages().get(this.pageIndex);
        for (IManualComponent c : p.getComponents()) {
            c.init();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int marginHorizontal = (this.field_146294_l - this.xSize) / 2;
        int marginVertical = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(marginHorizontal, marginVertical, 0, 0, this.xSize, this.ySize);
        ManualPage p = this.currentPage;
        for (IManualComponent c : p.getComponents()) {
            c.draw(mouseX, mouseY, partialTicks);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (IManualComponent c : p.getComponents()) {
            c.drawLater(mouseX, mouseY, partialTicks);
        }
    }

    public void updateButtons() {
        this.buttonNextPage.field_146125_m = this.pageIndex != this.currentTopic.getPages().size() - 1;
        this.buttonPreviousPage.field_146125_m = this.pageIndex != 0;
        this.buttonPrevTopic.field_146125_m = !this.isPrevTopic;
        this.buttonThisTopic.field_146125_m = this.isPrevTopic;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    ++this.pageIndex;
                    this.initComponents();
                    break;
                }
                case 1: {
                    --this.pageIndex;
                    this.initComponents();
                    break;
                }
                case 2: {
                    ManualTopic temp = this.currentTopic;
                    this.currentTopic = this.lastTopic;
                    this.lastTopic = temp;
                    this.isPrevTopic = true;
                    this.pageIndex = 0;
                    this.initComponents();
                    break;
                }
                case 3: {
                    ManualTopic temp2 = this.currentTopic;
                    this.currentTopic = this.lastTopic;
                    this.lastTopic = temp2;
                    this.isPrevTopic = false;
                    this.pageIndex = 0;
                    this.initComponents();
                }
            }
        }
        this.updateButtons();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        ManualPage p = this.currentPage;
        for (IManualComponent c : p.getComponents()) {
            if (!this.isHovering(c, mouseX, mouseY)) continue;
            if (mouseButton == 0) {
                c.onLeftClick(mouseX, mouseY);
                continue;
            }
            if (mouseButton != 1) continue;
            c.onRightClick(mouseX, mouseY);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        ManualPage p = this.currentPage;
        for (IManualComponent c : p.getComponents()) {
            c.update();
        }
    }

    public boolean isHovering(IManualComponent c, int mouseX, int mouseY) {
        return mouseX > c.getX() + 36 + this.guiLeft && mouseX < c.getX() + 36 + this.guiLeft + c.getObjectWidth() && mouseY > c.getY() + 16 + this.guiTop && mouseY < c.getY() + 16 + this.guiTop + c.getObjectHeight();
    }

    public void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-32.0f);
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight, float scale) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        tessellator.func_78381_a();
    }

    public void func_146285_a(ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        this.drawHoveringText(this.func_191927_a(stack), x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(typedChar, keyCode);
    }

    @SideOnly(value=Side.CLIENT)
    static class PrevPageButton
    extends GuiButton {
        private final boolean isForward;

        public PrevPageButton(int buttonId, int x, int y, boolean isForward) {
            super(buttonId, x, y, 18, 11, "");
            this.isForward = isForward;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int i = 48;
                int j = 229;
                if (flag) {
                    i += 22;
                }
                if (!this.isForward) {
                    j += 13;
                }
                mc.func_110434_K().func_110577_a(TEXTURE);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 18, 11);
                if (flag) {
                    GlStateManager.func_179094_E();
                    INSTANCE.func_146279_a(I18n.func_74838_a((String)"manual.topic.previous"), mouseX, mouseY);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean isForward;

        public NextPageButton(int buttonId, int x, int y, boolean isForwardIn) {
            super(buttonId, x, y, 23, 13, "");
            this.isForward = isForwardIn;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int i = 0;
                int j = 227;
                if (flag) {
                    i += 23;
                }
                if (!this.isForward) {
                    j += 13;
                }
                mc.func_110434_K().func_110577_a(TEXTURE);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 23, 13);
                if (flag) {
                    GlStateManager.func_179094_E();
                    INSTANCE.func_146279_a(I18n.func_74838_a((String)(this.isForward ? "manual.page.next" : "manual.page.previous")), mouseX, mouseY);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179121_F();
                }
            }
        }
    }
}

