/*
 * Decompiled with CFR 0.152.
 */
package com.animania.manual.components;

import com.animania.manual.components.IManualComponent;
import com.animania.manual.groups.ManualTopic;
import com.animania.manual.gui.GuiManual;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;

public class LinkComponent
implements IManualComponent {
    private ResourceLocation link;
    private String text;
    private GuiManual manual;
    private int x;
    private int y;
    private int absoluteX;
    private int absoluteY;
    private int objectWidth;
    private int objectHeight;
    private Minecraft mc;

    public LinkComponent(int x, int y, String buttonText, ResourceLocation link) {
        this.link = link;
        this.manual = GuiManual.INSTANCE;
        this.absoluteX = x + 36;
        this.absoluteY = y + 16;
        this.text = buttonText.trim();
        this.x = x;
        this.y = y;
        this.mc = Minecraft.func_71410_x();
        this.objectHeight = this.mc.field_71466_p.field_78288_b;
        this.objectWidth = this.mc.field_71466_p.func_78256_a(this.text);
    }

    @Override
    public void init() {
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        this.mc.field_71466_p.func_78276_b((this.isHovering(mouseX, mouseY) ? TextFormatting.BLUE + "" + TextFormatting.UNDERLINE : TextFormatting.BLUE) + this.text, this.absoluteX + this.manual.guiLeft, this.absoluteY + this.manual.guiTop, 0);
    }

    @Override
    public void drawLater(int mouseX, int mouseY, float partialTicks) {
        if (this.isHovering(mouseX, mouseY)) {
            ManualTopic t = this.manual.manualContent.get(this.link);
            String name = TextFormatting.DARK_RED + "INVALID LINK";
            if (t != null) {
                name = t.getName();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            this.manual.func_146279_a(name, mouseX, mouseY);
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
        }
    }

    private boolean isHovering(int mouseX, int mouseY) {
        return mouseX > this.absoluteX + this.manual.guiLeft && mouseX < this.absoluteX + this.manual.guiLeft + this.objectWidth && mouseY > this.absoluteY + this.manual.guiTop && mouseY < this.absoluteY + this.manual.guiTop + this.objectHeight;
    }

    @Override
    public void onLeftClick() {
        ManualTopic t = this.manual.manualContent.get(this.link);
        this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        if (t != null) {
            this.manual.lastTopic = this.manual.currentTopic;
            this.manual.currentTopic = t;
            this.manual.pageIndex = 0;
            this.manual.isPrevTopic = false;
            this.manual.updateButtons();
            this.manual.initComponents();
        }
    }

    @Override
    public void onRightClick() {
    }

    @Override
    public int getObjectWidth() {
        return this.objectWidth;
    }

    @Override
    public int getObjectHeight() {
        return this.objectHeight;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public IManualComponent setX(int x) {
        this.x = x;
        this.absoluteX = x + 36;
        return this;
    }

    @Override
    public IManualComponent setY(int y) {
        this.y = y;
        this.absoluteY = y + 16;
        return this;
    }

    public String toString() {
        return this.text + "@" + this.link;
    }
}

