/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.sheep;

import com.animania.common.entities.AnimalContainer;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.generic.ai.GenericAIAvoidEntity;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindSaltLick;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.entities.interfaces.IAnimaniaAnimalBase;
import com.animania.common.entities.sheep.EntityEweDorset;
import com.animania.common.entities.sheep.EntityEweFriesian;
import com.animania.common.entities.sheep.EntityEweMerino;
import com.animania.common.entities.sheep.EntityEweSuffolk;
import com.animania.common.entities.sheep.EntityLambBase;
import com.animania.common.entities.sheep.EntityLambDorset;
import com.animania.common.entities.sheep.EntityLambFriesian;
import com.animania.common.entities.sheep.EntityLambMerino;
import com.animania.common.entities.sheep.EntityLambSuffolk;
import com.animania.common.entities.sheep.EntityRamDorset;
import com.animania.common.entities.sheep.EntityRamFriesian;
import com.animania.common.entities.sheep.EntityRamMerino;
import com.animania.common.entities.sheep.EntityRamSuffolk;
import com.animania.common.entities.sheep.SheepType;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaSheep
extends EntitySheep
implements IShearable,
IAnimaniaAnimalBase {
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.sheepFood));
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Optional<UUID>> RIVAL_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> SHEARED_TIMER = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> DYE_COLOR = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final String[] SHEEP_TEXTURES = new String[]{"black", "white", "brown"};
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public SheepType sheepType;
    public GenericAIEatGrass<EntityAnimaniaSheep> field_146087_bs;
    protected boolean mateable = false;
    protected boolean headbutting = false;
    protected EntityGender gender;
    protected EnumDyeColor color;
    protected boolean hasRemovedBOP = false;

    public EntityAnimaniaSheep(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.field_146087_bs = new GenericAIEatGrass<EntityAnimaniaSheep>(this);
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, new GenericAIFindWater<EntityAnimaniaSheep>(this, 1.0, this.field_146087_bs, EntityAnimaniaSheep.class));
            this.field_70714_bg.func_75776_a(3, new GenericAIFindFood<EntityAnimaniaSheep>(this, 1.0, this.field_146087_bs, true));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, new GenericAIPanic<EntityAnimaniaSheep>(this, 2.2));
        this.field_70714_bg.func_75776_a(7, new GenericAITempt<EntityAnimaniaSheep>(this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, new GenericAITempt<EntityAnimaniaSheep>(this, 1.25, Item.func_150898_a((Block)Blocks.field_150327_N), false));
        this.field_70714_bg.func_75776_a(6, new GenericAITempt<EntityAnimaniaSheep>(this, 1.25, Item.func_150898_a((Block)Blocks.field_150328_O), false));
        this.field_70714_bg.func_75776_a(8, this.field_146087_bs);
        this.field_70714_bg.func_75776_a(9, new GenericAIAvoidEntity<EntityWolf>((EntityCreature)this, EntityWolf.class, 24.0f, 2.0, 2.2));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, new GenericAILookIdle<EntityAnimaniaSheep>(this));
        this.field_70714_bg.func_75776_a(12, new GenericAIFindSaltLick<EntityAnimaniaSheep>(this, 1.0, this.field_146087_bs));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(11, new GenericAISleep<EntityAnimaniaSheep>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.sheepBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.sheepBed2), EntityAnimaniaSheep.class));
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlayer.class}));
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
        this.func_110163_bv();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(RIVAL_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(SHEARED_TIMER, (Object)(AnimaniaConfig.careAndFeeding.woolRegrowthTimer + this.field_70146_Z.nextInt(500)));
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)EnumDyeColor.WHITE.func_176765_a());
        if (this instanceof EntityRamFriesian || this instanceof EntityEweFriesian || this instanceof EntityLambFriesian) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(3));
        } else if (this instanceof EntityRamDorset || this instanceof EntityEweDorset || this instanceof EntityLambDorset) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else if (this instanceof EntityRamMerino || this instanceof EntityEweMerino || this instanceof EntityLambMerino) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else if (this instanceof EntityRamSuffolk || this instanceof EntityEweSuffolk || this instanceof EntityLambSuffolk) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)0);
        }
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    public EntityAnimaniaSheep createChild(EntityAgeable ageable) {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityLambBase ? null : (this.sheepType.isPrime ? new ResourceLocation("animania", "sheep_prime") : new ResourceLocation("animania", "sheep_regular"));
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        if (!this.getSleeping()) {
            this.setFed(true);
            this.setHandFed(true);
            this.field_146087_bs.func_75249_e();
            this.eatTimer = 80;
            player.func_71064_a(this.sheepType.getAchievement(), 1);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
    }

    public boolean func_70892_o() {
        try {
            return this.getBoolFromDataManager(SHEARED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void func_70893_e(boolean sheared) {
        if (sheared) {
            this.field_70180_af.func_187227_b(SHEARED, (Object)true);
            this.setWoolRegrowthTimer(AnimaniaConfig.careAndFeeding.woolRegrowthTimer + this.field_70146_Z.nextInt(500));
        } else {
            this.field_70180_af.func_187227_b(SHEARED, (Object)false);
        }
    }

    public int getWoolRegrowthTimer() {
        try {
            return this.getIntFromDataManager(SHEARED_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setWoolRegrowthTimer(int time) {
        this.field_70180_af.func_187227_b(SHEARED_TIMER, (Object)time);
    }

    @Override
    public boolean getSleeping() {
        try {
            return this.getBoolFromDataManager(SLEEPING);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setSleeping(boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(SLEEPING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SLEEPING, (Object)false);
        }
    }

    @Override
    public Float getSleepTimer() {
        try {
            return Float.valueOf(this.getFloatFromDataManager(SLEEPTIMER));
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public void setSleepTimer(Float timer) {
        this.field_70180_af.func_187227_b(SLEEPTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    @Override
    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    @Override
    public boolean getHandFed() {
        try {
            return this.getBoolFromDataManager(HANDFED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setHandFed(boolean handfed) {
        this.field_70180_af.func_187227_b(HANDFED, (Object)handfed);
    }

    @Override
    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    protected void func_70619_bc() {
        this.eatTimer = this.field_146087_bs.getEatingGrassTimer();
        super.func_70619_bc();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    public void func_70615_aA() {
    }

    public boolean isDyeable() {
        return false;
    }

    public EnumDyeColor getDyeColor() {
        if (this.color == null) {
            this.color = EnumDyeColor.func_176764_b((int)this.getDyeColorNum());
        }
        return this.color;
    }

    public int getDyeColorNum() {
        return this.getIntFromDataManager(DYE_COLOR);
    }

    public void setDyeColorNum(int col) {
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)new Integer(col));
    }

    public void func_70636_d() {
        boolean sheared;
        if (!this.hasRemovedBOP && Loader.isModLoaded((String)"biomesoplenty")) {
            Iterator it = this.field_70714_bg.field_75782_a.iterator();
            while (it.hasNext()) {
                EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
                EntityAIBase ai = entry.field_75733_a;
                try {
                    if (!Class.forName("biomesoplenty.common.entities.ai.EntityAIEatBOPGrass").isInstance(ai)) continue;
                    entry.field_188524_c = false;
                    ai.func_75251_c();
                    it.remove();
                }
                catch (Exception exception) {}
            }
            this.hasRemovedBOP = true;
        }
        if (this.getAge() == 0) {
            this.setAge(1);
        }
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.fedTimer > -1 && !AnimaniaConfig.gameRules.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !AnimaniaConfig.gameRules.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
            if (AnimaniaConfig.gameRules.animalsStarve) {
                if (this.damageTimer >= AnimaniaConfig.careAndFeeding.starvationTimer) {
                    this.func_70097_a(DamageSource.field_76366_f, 4.0f);
                    this.damageTimer = 0;
                }
                ++this.damageTimer;
            }
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && !this.getSleeping() && this.getHandFed() && AnimaniaConfig.gameRules.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if (sheared = this.func_70892_o()) {
            int shearedTimer = this.getWoolRegrowthTimer();
            this.setWoolRegrowthTimer(--shearedTimer);
            if (shearedTimer < 0) {
                this.func_70893_e(false);
            }
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (stack.func_77973_b() instanceof ItemShears && !this.func_70892_o() && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
            }
            player.func_184609_a(hand);
            if (this.getSleeping()) {
                this.setSleeping(false);
            }
        }
        if (stack.func_77973_b() instanceof ItemDye && !this.func_70631_g_() && !this.func_70892_o()) {
            if (this.isDyeable()) {
                EnumDyeColor col = EnumDyeColor.func_176766_a((int)stack.func_77952_i());
                if (this.getDyeColor() != col) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    this.color = col;
                    this.setDyeColorNum(col.func_176765_a());
                    return true;
                }
                return true;
            }
            return false;
        }
        if (stack != ItemStack.field_190927_a && AnimaniaHelper.isWaterContainer(stack) && !this.getSleeping()) {
            if (!player.func_184812_l_()) {
                ItemStack emptied = AnimaniaHelper.emptyContainer(stack);
                stack.func_190918_g(1);
                AnimaniaHelper.addItem(player, emptied);
            }
            this.eatTimer = 40;
            this.field_146087_bs.func_75249_e();
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() == Items.field_151133_ar && !this.getSleeping()) {
            return false;
        }
        if (this.func_70877_b(stack)) {
            this.func_175505_a(player, stack);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    public UUID getMateUniqueId() {
        if (this.mateable) {
            try {
                UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
                return id;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void func_146082_f(EntityPlayer player) {
        if (!this.getSleeping()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return this.mateable && stack != ItemStack.field_190927_a && this.isSheepBreedingItem(stack.func_77973_b());
    }

    private boolean isSheepBreedingItem(Item itemIn) {
        return TEMPTATION_ITEMS.contains(itemIn) || itemIn == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getMateUniqueId() != null) {
            compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
        }
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Handfed", this.getHandFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74757_a("Sheared", this.func_70892_o());
        compound.func_74768_a("ColorNumber", this.getColorNumber());
        compound.func_74768_a("Age", this.getAge());
        compound.func_74757_a("Sleep", this.getSleeping());
        compound.func_74776_a("SleepTimer", this.getSleepTimer().floatValue());
        compound.func_74768_a("DyeColor", this.getDyeColorNum());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("MateUUID", 8)) {
            String s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            String s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        this.setColorNumber(compound.func_74762_e("ColorNumber"));
        this.setFed(compound.func_74767_n("Fed"));
        this.setHandFed(compound.func_74767_n("Handfed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.func_70893_e(compound.func_74767_n("Sheared"));
        this.setAge(compound.func_74762_e("Age"));
        this.setSleeping(compound.func_74767_n("Sleep"));
        this.setSleepTimer(Float.valueOf(compound.func_74760_g("SleepTimer")));
        this.setDyeColorNum(compound.func_74762_e("DyeColor"));
    }

    public int getAge() {
        try {
            return this.getIntFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public int getColorNumber() {
        try {
            return this.getIntFromDataManager(COLOR_NUM);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.sheepType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.func_70892_o() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return null;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getItemStackFromDataManager(DataParameter<ItemStack> key) {
        try {
            return (ItemStack)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return ItemStack.field_190927_a;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }
}

