/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.peacocks;

import com.animania.Animania;
import com.animania.common.ModSoundEvents;
import com.animania.common.blocks.BlockSeeds;
import com.animania.common.entities.AnimalContainer;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.amphibians.EntityAmphibian;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.interfaces.IAnimaniaAnimalBase;
import com.animania.common.entities.peacocks.EntityPeachickBase;
import com.animania.common.entities.peacocks.EntityPeacockBase;
import com.animania.common.entities.peacocks.PeacockType;
import com.animania.common.entities.peacocks.ai.EntityAIWatchClosestFromSide;
import com.animania.common.handler.ItemHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.compat.top.providers.entity.TOPInfoProviderBase;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityAnimaniaPeacock
extends EntityAnimal
implements TOPInfoProviderBase,
IAnimaniaAnimalBase {
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaPeacock.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaPeacock.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaPeacock.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaPeacock.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.peacockFood));
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaPeacock.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaPeacock.class, (DataSerializer)DataSerializers.field_187193_c);
    protected ResourceLocation resourceLocation = new ResourceLocation("animania:textures/entity/peacocks/peacock_blue.png");
    protected ResourceLocation resourceLocationBlink = new ResourceLocation("animania:textures/entity/peacocks/peacock_blue_blink.png");
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    protected int fedTimer;
    protected int wateredTimer;
    protected int happyTimer;
    public int blinkTimer;
    protected int damageTimer;
    public PeacockType type;
    private int featherCounter;
    protected EntityGender gender;
    public int lidCol;

    public EntityAnimaniaPeacock(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(1, new GenericAIFindWater<EntityAnimaniaPeacock>(this, 1.0, null, EntityAnimaniaPeacock.class, true));
            this.field_70714_bg.func_75776_a(1, new GenericAIFindFood<EntityAnimaniaPeacock>(this, 1.0, null, true));
        }
        this.field_70714_bg.func_75776_a(2, new GenericAIPanic<EntityAnimaniaPeacock>(this, 1.4));
        this.field_70714_bg.func_75776_a(3, new GenericAITempt<EntityAnimaniaPeacock>(this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosestFromSide((EntityLiving)this, EntityPlayer.class, 6.0f));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(6, new GenericAISleep<EntityAnimaniaPeacock>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.peacockBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.peacockBed2), EntityAnimaniaPeacock.class));
        }
        this.field_70714_bg.func_75776_a(11, new GenericAILookIdle<EntityAnimaniaPeacock>(this));
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers) {
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.2f));
            this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer * 2 + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer * 2 + this.field_70146_Z.nextInt(100);
        this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
        this.func_110163_bv();
        this.happyTimer = 60;
        this.featherCounter = AnimaniaConfig.careAndFeeding.featherTimer;
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.setHandFed(true);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190920_e(stack.func_190916_E() - 1);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (stack != ItemStack.field_190927_a && AnimaniaHelper.isWaterContainer(stack) && !this.getSleeping()) {
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (this.func_70877_b(stack)) {
            this.func_175505_a(player, stack);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        if (entityIn instanceof EntityAmphibian) {
            this.setFed(true);
        }
        if (entityIn instanceof EntityPlayer) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, this.field_70165_t - entityIn.field_70165_t, this.field_70161_v - entityIn.field_70161_v);
        }
        return flag;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Fed", this.getFed());
        nbttagcompound.func_74757_a("Handfed", this.getHandFed());
        nbttagcompound.func_74757_a("Watered", this.getWatered());
        nbttagcompound.func_74768_a("Age", this.getAge());
        nbttagcompound.func_74757_a("Sleep", this.getSleeping());
        nbttagcompound.func_74776_a("SleepTimer", this.getSleepTimer().floatValue());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setFed(nbttagcompound.func_74767_n("Fed"));
        this.setHandFed(nbttagcompound.func_74767_n("Handfed"));
        this.setWatered(nbttagcompound.func_74767_n("Watered"));
        this.setAge(nbttagcompound.func_74762_e("Age"));
        this.setSleeping(nbttagcompound.func_74767_n("Sleep"));
        this.setSleepTimer(Float.valueOf(nbttagcompound.func_74760_g("SleepTimer")));
    }

    public int getAge() {
        try {
            return this.getIntFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    @Override
    public boolean getSleeping() {
        try {
            return this.getBoolFromDataManager(SLEEPING);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setSleeping(boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(SLEEPING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SLEEPING, (Object)false);
        }
    }

    @Override
    public boolean getHandFed() {
        try {
            return this.getBoolFromDataManager(HANDFED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setHandFed(boolean handfed) {
        this.field_70180_af.func_187227_b(HANDFED, (Object)handfed);
    }

    @Override
    public Float getSleepTimer() {
        return Float.valueOf(-100.0f);
    }

    @Override
    public void setSleepTimer(Float timer) {
        this.field_70180_af.func_187227_b(SLEEPTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityPeachickBase ? null : new ResourceLocation("animania", "peacocks/peacock_" + this.type.toString().toLowerCase());
    }

    public void func_70636_d() {
        if (this.func_110167_bD() && this.getSleeping()) {
            this.setSleeping(false);
        }
        if (this.getAge() == 0) {
            this.setAge(1);
        }
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E || this.func_184218_aH() ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && !this.func_184218_aH() && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && !this.func_184218_aH() && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.fedTimer > -1 && !AnimaniaConfig.gameRules.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !AnimaniaConfig.gameRules.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
            if (AnimaniaConfig.gameRules.animalsStarve) {
                if (this.damageTimer >= AnimaniaConfig.careAndFeeding.starvationTimer) {
                    this.func_70097_a(DamageSource.field_76366_f, 4.0f);
                    this.damageTimer = 0;
                }
                ++this.damageTimer;
            }
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && !this.getSleeping() && AnimaniaConfig.gameRules.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if (this instanceof EntityPeacockBase && AnimaniaConfig.gameRules.chickensDropFeathers) {
            --this.featherCounter;
            if (this.featherCounter <= 0) {
                this.featherCounter = AnimaniaConfig.careAndFeeding.featherTimer;
                Item feather = null;
                feather = this.type == PeacockType.BLUE ? ItemHandler.peacockFeatherBlue : (this.type == PeacockType.CHARCOAL ? ItemHandler.peacockFeatherCharcoal : (this.type == PeacockType.OPAL ? ItemHandler.peacockFeatherOpal : (this.type == PeacockType.PEACH ? ItemHandler.peacockFeatherPeach : (this.type == PeacockType.PURPLE ? ItemHandler.peacockFeatherPurple : (this.type == PeacockType.TAUPE ? ItemHandler.peacockFeatherTaupe : ItemHandler.peacockFeatherWhite)))));
                if (feather != null && !this.field_70170_p.field_72995_K) {
                    ItemStack bob = new ItemStack(feather, 1);
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, bob);
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
        }
    }

    @Override
    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    @Override
    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    protected void fall(float p_70069_1_) {
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.05f, 1.0f);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        passenger.func_70107_b(this.field_70165_t + (double)(0.1f * f), this.field_70163_u + (double)(this.field_70131_O * 0.5f) + passenger.func_70033_W() + 0.0, this.field_70161_v - (double)(0.1f * f1));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected SoundEvent func_184639_G() {
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = Animania.RANDOM.nextInt(num = happy == 2 ? 20 : (happy == 1 ? 40 : 100))) == 0) {
            return ModSoundEvents.peacock1;
        }
        if (chooser == 1) {
            return ModSoundEvents.peacock2;
        }
        if (chooser == 2) {
            return ModSoundEvents.peacock3;
        }
        if (chooser == 3) {
            return ModSoundEvents.peacock4;
        }
        if (chooser == 4) {
            return ModSoundEvents.peacock5;
        }
        if (chooser == 5) {
            return null;
        }
        if (chooser == 6) {
            return ModSoundEvents.peacock7;
        }
        if (chooser == 7) {
            return ModSoundEvents.peacock8;
        }
        if (chooser == 8) {
            return ModSoundEvents.peacock9;
        }
        if (chooser == 9) {
            return ModSoundEvents.peacock10;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        int chooser = Animania.RANDOM.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.peacockHurt1;
        }
        return ModSoundEvents.peacockHurt2;
    }

    protected SoundEvent func_184615_bR() {
        int chooser = Animania.RANDOM.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.peacockHurt1;
        }
        return ModSoundEvents.peacockHurt2;
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.type, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getItemStackFromDataManager(DataParameter<ItemStack> key) {
        try {
            return (ItemStack)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return ItemStack.field_190927_a;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public Class[] getFoodBlocks() {
        return new Class[]{BlockSeeds.class};
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }
}

