/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.horses.ai;

import com.animania.Animania;
import com.animania.common.entities.horses.EntityAnimaniaHorse;
import com.animania.common.entities.horses.EntityFoalBase;
import com.animania.common.entities.horses.EntityMareBase;
import com.animania.common.entities.horses.EntityStallionBase;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.world.World;

public class EntityAIMateHorses
extends EntityAIBase {
    private final EntityAnimaniaHorse theAnimal;
    World theWorld;
    private EntityAnimal targetMate;
    int courtshipTimer;
    double moveSpeed;
    private int delayCounter;

    public EntityAIMateHorses(EntityAnimaniaHorse animal, double speedIn) {
        this.theAnimal = animal;
        this.theWorld = animal.field_70170_p;
        this.moveSpeed = speedIn;
        this.func_75248_a(3);
        this.courtshipTimer = 20;
        this.delayCounter = 0;
    }

    public boolean func_75250_a() {
        ++this.delayCounter;
        if (this.delayCounter > AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            if (!this.theAnimal.field_70170_p.func_72935_r() || this.theAnimal.getSleeping()) {
                this.delayCounter = 0;
                return false;
            }
            if (this.theAnimal instanceof EntityFoalBase || this.theAnimal instanceof EntityMareBase || this.theAnimal.func_70090_H()) {
                this.delayCounter = 0;
                return false;
            }
            EntityAnimaniaHorse thisAnimal = this.theAnimal;
            if (AnimaniaConfig.careAndFeeding.manualBreeding) {
                if (!thisAnimal.getHandFed()) {
                    this.delayCounter = 0;
                    return false;
                }
            } else {
                List list = this.theWorld.field_72996_f;
                int cowCount = 0;
                int num = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EntityAnimaniaHorse)) continue;
                    ++num;
                }
                cowCount = num;
                if (cowCount > AnimaniaConfig.spawn.spawnLimitHorses && !thisAnimal.getHandFed()) {
                    this.delayCounter = 0;
                    return false;
                }
            }
            this.targetMate = this.getNearbyMate();
            if (this.targetMate != null && Animania.RANDOM.nextInt(20) == 0) {
                this.delayCounter = 0;
                this.func_75251_c();
                return false;
            }
            return this.targetMate != null;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.targetMate != null) {
            return this.targetMate.func_70089_S();
        }
        return false;
    }

    public void func_75251_c() {
        this.targetMate = null;
    }

    public void func_75246_d() {
        if (this.targetMate != null) {
            EntityMareBase tm = (EntityMareBase)this.targetMate;
            if (!tm.getPregnant() && tm.getFertile()) {
                this.targetMate = this.getNearbyMate();
            } else {
                this.theAnimal.func_70875_t();
                this.func_75251_c();
                this.theAnimal.func_70661_as().func_75499_g();
                this.delayCounter = 0;
            }
        }
    }

    private EntityAnimal getNearbyMate() {
        if (this.theAnimal instanceof EntityStallionBase) {
            UUID mateID = null;
            EntityStallionBase entity2 = (EntityStallionBase)this.theAnimal;
            if (entity2.getMateUniqueId() != null) {
                mateID = entity2.getMateUniqueId();
            }
            if (mateID != null) {
                List<EntityMareBase> entities = AnimaniaHelper.getEntitiesInRange(EntityMareBase.class, 3.0, this.theAnimal.field_70170_p, (Entity)this.theAnimal);
                for (int k = 0; k <= entities.size() - 1; ++k) {
                    EntityMareBase entity = entities.get(k);
                    boolean allowBreeding = true;
                    if (AnimaniaConfig.careAndFeeding.manualBreeding && !entity.getHandFed()) {
                        allowBreeding = false;
                    }
                    if (!entity.getPersistentID().equals(mateID) || !entity.getFertile() || entity.getSleeping() || entity.getPregnant() || !allowBreeding || !entity.func_70685_l((Entity)entity2)) continue;
                    --this.courtshipTimer;
                    if (this.courtshipTimer < 0) {
                        this.theAnimal.func_146082_f(null);
                        this.courtshipTimer = 20;
                        k = entities.size();
                        entity.setPregnant(true);
                        entity.setFertile(false);
                        entity.setHandFed(false);
                        this.delayCounter = 0;
                        return entity;
                    }
                    if (!allowBreeding) continue;
                    k = entities.size();
                    this.theAnimal.func_146082_f(null);
                    this.theAnimal.func_70671_ap().func_75651_a((Entity)entity, 10.0f, (float)this.theAnimal.func_70646_bf());
                    this.theAnimal.func_70661_as().func_75497_a((Entity)entity, this.moveSpeed);
                    entity.func_70671_ap().func_75651_a((Entity)this.theAnimal, 10.0f, (float)entity.func_70646_bf());
                    entity.func_70661_as().func_75497_a((Entity)this.theAnimal, this.moveSpeed);
                    return null;
                }
            } else {
                List<EntityMareBase> entities = AnimaniaHelper.getEntitiesInRange(EntityMareBase.class, 5.0, this.theAnimal.field_70170_p, (Entity)this.theAnimal);
                for (int k = 0; k <= entities.size() - 1; ++k) {
                    EntityMareBase entity = entities.get(k);
                    boolean allowBreeding = true;
                    if (AnimaniaConfig.careAndFeeding.manualBreeding && !entity.getHandFed()) {
                        allowBreeding = false;
                    }
                    --this.courtshipTimer;
                    if (entity.getMateUniqueId() == null && this.courtshipTimer < 0 && entity.getFertile() && !entity.getSleeping() && !entity.getPregnant() && allowBreeding && entity.func_70685_l((Entity)entity2)) {
                        ((EntityStallionBase)this.theAnimal).setMateUniqueId(entity.getPersistentID());
                        entity.setMateUniqueId(this.theAnimal.getPersistentID());
                        this.theAnimal.func_146082_f(null);
                        this.courtshipTimer = 20;
                        k = entities.size();
                        entity.setPregnant(true);
                        entity.setFertile(false);
                        entity.setHandFed(false);
                        this.delayCounter = 0;
                        return entity;
                    }
                    if (entity.getMateUniqueId() != null || entity.getPregnant() || entity.getSleeping() || !entity.getFertile() || !allowBreeding) continue;
                    k = entities.size();
                    this.theAnimal.func_146082_f(null);
                    this.theAnimal.func_70671_ap().func_75651_a((Entity)entity, 10.0f, (float)this.theAnimal.func_70646_bf());
                    this.theAnimal.func_70661_as().func_75497_a((Entity)entity, this.moveSpeed);
                    entity.func_70671_ap().func_75651_a((Entity)this.theAnimal, 10.0f, (float)entity.func_70646_bf());
                    entity.func_70661_as().func_75497_a((Entity)this.theAnimal, this.moveSpeed);
                    return null;
                }
            }
        }
        this.delayCounter = 0;
        return null;
    }
}

