/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.cows;

import com.animania.Animania;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.cows.EntityAnimaniaCow;
import com.animania.common.entities.cows.EntityCalfBase;
import com.animania.common.entities.cows.EntityCowBase;
import com.animania.common.entities.cows.ai.EntityAIAttackMeleeBulls;
import com.animania.common.entities.generic.ai.GenericAIMate;
import com.animania.common.entities.interfaces.IMateable;
import com.animania.common.entities.interfaces.ISterilizable;
import com.animania.common.handler.DamageSourceHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.config.AnimaniaConfig;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBullBase
extends EntityAnimaniaCow
implements TOPInfoProviderMateable,
IMateable,
ISterilizable {
    protected static final DataParameter<Boolean> FIGHTING = EntityDataManager.func_187226_a(EntityBullBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> STERILIZED = EntityDataManager.func_187226_a(EntityBullBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityBullBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.6f, 1.8f);
        this.field_70130_N = 1.6f;
        this.field_70131_O = 1.8f;
        this.gender = EntityGender.MALE;
        this.field_70138_W = 1.1f;
        this.mateable = true;
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers && !this.getSterilized()) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMeleeBulls(this, 1.8, false));
        }
        if (!this.getSterilized()) {
            this.field_70714_bg.func_75776_a(3, new GenericAIMate(this, 1.0, EntityCowBase.class, EntityCalfBase.class, EntityAnimaniaCow.class));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIGHTING, (Object)false);
        this.field_70180_af.func_187214_a(STERILIZED, (Object)false);
    }

    public void func_146082_f(EntityPlayer player) {
        if (!this.getFighting() && !this.getSleeping()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
    }

    public boolean getFighting() {
        try {
            return this.getBoolFromDataManager(FIGHTING);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFighting(boolean fighting) {
        if (fighting) {
            this.field_70180_af.func_187227_b(FIGHTING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(FIGHTING, (Object)false);
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getSleeping()) {
            this.setSleeping(false);
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = false;
        if (this.func_70685_l(entityIn) && this.func_70032_d(entityIn) <= 2.0f) {
            flag = entityIn.func_70097_a(DamageSourceHandler.bullDamage, 5.0f);
            if (flag) {
                this.func_174815_a((EntityLivingBase)this, entityIn);
            }
            if (entityIn instanceof EntityPlayer) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, (this.field_70165_t - entityIn.field_70165_t) / 2.0, (this.field_70161_v - entityIn.field_70161_v) / 2.0);
            }
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = Animania.RANDOM.nextInt(num = happy == 2 ? 18 : (happy == 1 ? 36 : 60))) == 0) {
            return ModSoundEvents.bullMoo1;
        }
        if (chooser == 1) {
            return ModSoundEvents.bullMoo2;
        }
        if (chooser == 2) {
            return ModSoundEvents.bullMoo3;
        }
        if (chooser == 3) {
            return ModSoundEvents.bullMoo4;
        }
        if (chooser == 4) {
            return ModSoundEvents.bullMoo5;
        }
        if (chooser == 5) {
            return ModSoundEvents.bullMoo6;
        }
        if (chooser == 6) {
            return ModSoundEvents.bullMoo7;
        }
        if (chooser == 7) {
            return ModSoundEvents.bullMoo8;
        }
        if (chooser == 8) {
            return ModSoundEvents.moo4;
        }
        if (chooser == 9) {
            return ModSoundEvents.moo8;
        }
        if (chooser == 10) {
            return ModSoundEvents.moo4;
        }
        return ModSoundEvents.moo8;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        int chooser = Animania.RANDOM.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.angryBull1;
        }
        if (chooser == 1) {
            return ModSoundEvents.angryBull2;
        }
        return ModSoundEvents.angryBull3;
    }

    protected SoundEvent func_184615_bR() {
        return Animania.RANDOM.nextBoolean() ? ModSoundEvents.cowDeath1 : ModSoundEvents.cowDeath2;
    }

    @Override
    public void func_70636_d() {
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
                if (this.getMateUniqueId() != null) {
                    UUID mate = this.getMateUniqueId();
                    boolean mateReset = true;
                    List<EntityCowBase> entities = AnimaniaHelper.getEntitiesInRange(EntityCowBase.class, 20.0, this.field_70170_p, (Entity)this);
                    for (int k = 0; k <= entities.size() - 1; ++k) {
                        UUID id;
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(id = entity.getPersistentID()).equals(this.getMateUniqueId()) || entity.field_70128_L) continue;
                        mateReset = false;
                        EntityCowBase fem = (EntityCowBase)entity;
                        if (!fem.getPregnant()) break;
                        this.setHandFed(false);
                        break;
                    }
                    if (mateReset) {
                        this.setMateUniqueId(null);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (!this.getFighting()) {
            return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 156 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 160) - p_70894_1_) / 4.0f));
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 156 && !this.getFighting()) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 64.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public EntityBullBase createChild(EntityAgeable p_90011_1_) {
        return null;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Fighting", this.getFighting());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFighting(compound.func_74767_n("Fighting"));
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af() && this.getMateUniqueId() != null) {
            probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
        }
        TOPInfoProviderMateable.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }

    @Override
    public boolean getSterilized() {
        return this.getBoolFromDataManager(STERILIZED);
    }

    @Override
    public void setSterilized(boolean sterilized) {
        this.field_70180_af.func_187227_b(STERILIZED, (Object)sterilized);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74757_a("Sterilized", this.getSterilized());
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        this.setSterilized(compound.func_74767_n("Sterilized"));
        super.func_70020_e(compound);
    }

    @Override
    public void sterilize() {
        Iterator it = this.field_70714_bg.field_75782_a.iterator();
        while (it.hasNext()) {
            EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
            EntityAIBase ai = entry.field_75733_a;
            if (!(ai instanceof GenericAIMate) && !(ai instanceof EntityAIAttackMeleeBulls)) continue;
            entry.field_188524_c = false;
            ai.func_75251_c();
            it.remove();
        }
        this.setSterilized(true);
    }
}

