/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.cows;

import com.animania.client.models.ModelCalfLonghorn;
import com.animania.client.render.layer.LayerBlinking;
import com.animania.common.entities.cows.EntityAnimaniaCow;
import com.animania.common.entities.cows.EntityCalfBase;
import com.animania.common.entities.cows.EntityCalfHighland;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCalfHighland<T extends EntityCalfHighland>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation cowTextures = new ResourceLocation("animania:textures/entity/cows/calf_highland.png");
    private static final ResourceLocation cowTexturesBlink = new ResourceLocation("animania:textures/entity/cows/calf_blink.png");

    public RenderCalfHighland(RenderManager rm) {
        super(rm, (ModelBase)new ModelCalfLonghorn(), 0.5f);
        this.func_177094_a(new LayerBlinking(this, cowTexturesBlink, 5975835));
    }

    protected ResourceLocation getCowTextures(T par1EntityCow) {
        return cowTextures;
    }

    protected ResourceLocation getCowTexturesBlink(T par1EntityCow) {
        return cowTexturesBlink;
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale(entityliving, f);
    }

    protected void preRenderScale(T entity, float f) {
        float age = ((EntityCalfBase)entity).getEntityAge();
        GL11.glScalef((float)(1.0f + age), (float)(1.0f + age), (float)(1.0f + age));
        T entityCow = entity;
        if (((EntityAnimaniaCow)entityCow).getSleeping()) {
            float sleepTimer = ((EntityAnimaniaCow)entityCow).getSleepTimer().floatValue();
            if (sleepTimer > -0.55f) {
                sleepTimer -= 0.01f;
            }
            ((EntityAnimaniaCow)entity).setSleepTimer(Float.valueOf(sleepTimer));
            GlStateManager.func_179109_b((float)-0.25f, (float)(((EntityCalfHighland)entity).field_70131_O - 1.95f - sleepTimer), (float)-0.25f);
            GlStateManager.func_179114_b((float)6.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            ((EntityAnimaniaCow)entityCow).setSleeping(false);
            ((EntityAnimaniaCow)entityCow).setSleepTimer(Float.valueOf(0.0f));
        }
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return this.getCowTextures(entity);
    }

    static class Factory<T extends EntityCalfHighland>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderCalfHighland(manager);
        }
    }
}

