/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.ILocatable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import reborncore.api.power.ExternalPowerHandler;
import reborncore.common.powerSystem.TilePowerAcceptor;

public class IC2EnergyBase
implements IEnergyTile,
IEnergySink,
IEnergySource,
ExternalPowerHandler,
ILocatable {
    TilePowerAcceptor powerAcceptor;
    protected boolean addedToEnet;

    public IC2EnergyBase(TilePowerAcceptor powerAcceptor) {
        this.powerAcceptor = powerAcceptor;
    }

    public double getDemandedEnergy() {
        return this.powerAcceptor.getMaxPower() - this.powerAcceptor.getEnergy();
    }

    public int getSinkTier() {
        return this.powerAcceptor.getTier().getIC2Tier();
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double used = this.powerAcceptor.addEnergy(amount);
        return amount - used;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return this.powerAcceptor.canAcceptEnergy(enumFacing);
    }

    public double getOfferedEnergy() {
        return Math.min(this.powerAcceptor.getEnergy(), this.powerAcceptor.getMaxOutput());
    }

    public void drawEnergy(double amount) {
        this.powerAcceptor.useEnergy((double)((int)amount));
    }

    public int getSourceTier() {
        return this.powerAcceptor.getTier().getIC2Tier();
    }

    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        return this.powerAcceptor.canProvideEnergy(enumFacing);
    }

    public void tick() {
        if (this.powerAcceptor.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
    }

    public void unload() {
        if (this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    public void invalidate() {
        this.unload();
    }

    public BlockPos getPosition() {
        return this.powerAcceptor.func_174877_v();
    }

    public World getWorldObj() {
        return this.powerAcceptor.func_145831_w();
    }
}

