/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openblocks.api.IElevatorBlock;
import openblocks.common.tileentity.TileEntityElevatorRotating;
import openmods.block.OpenBlock;
import openmods.colors.ColorMeta;
import openmods.geometry.Orientation;

public class BlockElevatorRotating
extends OpenBlock.FourDirections
implements IElevatorBlock {
    public static final PropertyEnum<ColorMeta> COLOR = PropertyEnum.func_177709_a((String)"color", ColorMeta.class);

    public BlockElevatorRotating() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a(COLOR, (Comparable)ColorMeta.WHITE));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), COLOR});
    }

    private static ColorMeta getColorMeta(IBlockAccess world, BlockPos pos) {
        TileEntityElevatorRotating te = (TileEntityElevatorRotating)((Object)BlockElevatorRotating.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityElevatorRotating.class));
        return te != null ? te.getColor() : ColorMeta.WHITE;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        ColorMeta color = BlockElevatorRotating.getColorMeta(world, pos);
        return state.func_177226_a(COLOR, (Comparable)color);
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        ColorMeta next;
        ColorMeta current;
        if (world.field_72995_K) {
            return false;
        }
        TileEntityElevatorRotating te = (TileEntityElevatorRotating)((Object)BlockElevatorRotating.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityElevatorRotating.class));
        if (te != null && (current = te.getColor()) != (next = ColorMeta.fromVanillaEnum((EnumDyeColor)color))) {
            te.setColor(next);
            return true;
        }
        return false;
    }

    @Override
    public EnumDyeColor getColor(World world, BlockPos pos, IBlockState state) {
        return BlockElevatorRotating.getColorMeta((IBlockAccess)world, (BlockPos)pos).vanillaEnum;
    }

    @Override
    public IElevatorBlock.PlayerRotation getRotation(World world, BlockPos pos, IBlockState state) {
        Orientation orientation = this.getOrientation((IBlockAccess)world, pos);
        EnumFacing rot = orientation.north();
        switch (rot) {
            case NORTH: {
                return IElevatorBlock.PlayerRotation.NORTH;
            }
            case SOUTH: {
                return IElevatorBlock.PlayerRotation.SOUTH;
            }
            case WEST: {
                return IElevatorBlock.PlayerRotation.WEST;
            }
            case EAST: {
                return IElevatorBlock.PlayerRotation.EAST;
            }
        }
        return IElevatorBlock.PlayerRotation.NONE;
    }
}

