/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.common.HeightMapData;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;
import openmods.network.event.EventDirection;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventMeta;

public class MapDataManager {
    public static final MapDataManager instance = new MapDataManager();
    private Set<Block> blockBlacklist;
    private Set<Integer> mapsToUpdate = Sets.newHashSet();

    public static int createNewMap(World world, byte scale) {
        int id = world.func_72841_b("height_map");
        HeightMapData data = new HeightMapData(id, false);
        data.scale = scale;
        data.func_76185_a();
        world.func_72823_a(data.field_76190_i, (WorldSavedData)data);
        return id;
    }

    public static HeightMapData getMapData(World world, int mapId) {
        if (mapId < 0) {
            return HeightMapData.INVALID;
        }
        String name = HeightMapData.getMapName(mapId);
        HeightMapData result = (HeightMapData)world.func_72943_a(HeightMapData.class, name);
        return result != null ? result : HeightMapData.EMPTY;
    }

    public static void setMapData(World world, HeightMapData data) {
        world.func_72823_a(data.field_76190_i, (WorldSavedData)data);
    }

    @SubscribeEvent
    public void onMapDataRequest(MapDataRequestEvent evt) {
        World world = evt.sender.field_70170_p;
        MapDataResponseEvent response = new MapDataResponseEvent();
        TIntHashSet missingMaps = new TIntHashSet();
        for (Integer mapId : evt.mapIds) {
            HeightMapData map = MapDataManager.getMapData(world, mapId);
            if (map != null && !map.isEmpty()) {
                response.maps.put(mapId, map);
                continue;
            }
            missingMaps.add(mapId.intValue());
        }
        if (!missingMaps.isEmpty()) {
            boolean lessThan16 = missingMaps.forEach(value -> value < 16);
            if (Config.alwaysReportInvalidMapRequests || !lessThan16 || !Loader.isModLoaded((String)"NotEnoughItems")) {
                Log.info((String)"Player %s asked for non-existent maps %s", (Object[])new Object[]{evt.sender, missingMaps.toString()});
            }
        }
        if (!evt.mapIds.isEmpty()) {
            evt.reply(response);
        }
    }

    @SubscribeEvent
    public void onMapDataResponse(MapDataResponseEvent evt) {
        World world = evt.sender.field_70170_p;
        for (Map.Entry<Integer, HeightMapData> e : evt.maps.entrySet()) {
            HeightMapData mapData = e.getValue();
            world.func_72823_a(mapData.field_76190_i, (WorldSavedData)mapData);
        }
    }

    @SubscribeEvent
    public void onMapUpdates(MapUpdatesEvent evt) {
        World world = evt.sender.field_70170_p;
        HashSet mapsToUpdate = Sets.newHashSet();
        for (Integer mapId : evt.mapIds) {
            HeightMapData map = MapDataManager.getMapData(world, mapId);
            if (map == null) continue;
            mapsToUpdate.add(mapId);
        }
        if (!mapsToUpdate.isEmpty()) {
            MapDataRequestEvent request = new MapDataRequestEvent();
            request.mapIds = Lists.newArrayList((Iterable)mapsToUpdate);
            evt.reply(request);
        }
    }

    public void sendUpdates(MinecraftServer server) {
        if (this.mapsToUpdate.isEmpty()) {
            return;
        }
        MapUpdatesEvent evt = new MapUpdatesEvent();
        evt.mapIds.addAll(this.mapsToUpdate);
        this.mapsToUpdate.clear();
        evt.sendToAll();
    }

    public void markDataUpdated(World world, int mapId) {
        HeightMapData data = MapDataManager.getMapData(world, mapId);
        data.func_76185_a();
        this.mapsToUpdate.add(mapId);
    }

    public static void requestMapData(World world, int mapId) {
        if (world.field_72995_K) {
            MapDataRequestEvent evt = new MapDataRequestEvent();
            evt.mapIds.add(mapId);
            evt.sendToServer();
            HeightMapData stub = new HeightMapData(mapId, true);
            world.func_72823_a(stub.field_76190_i, (WorldSavedData)stub);
        }
    }

    private Set<Block> getBlacklist() {
        if (this.blockBlacklist == null) {
            this.blockBlacklist = Sets.newIdentityHashSet();
            for (String entry : Config.mapBlacklist) {
                try {
                    ResourceLocation loc = new ResourceLocation(entry);
                    if (Block.field_149771_c.func_148741_d((Object)loc)) {
                        Block block = (Block)Block.field_149771_c.func_82594_a((Object)loc);
                        this.blockBlacklist.add(block);
                        continue;
                    }
                    Log.debug((String)"Can't find block %s", (Object[])new Object[]{loc});
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Invalid entry in map blacklist: %s", (Object[])new Object[]{entry});
                }
            }
        }
        return this.blockBlacklist;
    }

    @SubscribeEvent
    public void onReconfig(ConfigurationChange.Post evt) {
        if (evt.check("cartographer", "blockBlacklist")) {
            this.blockBlacklist = null;
        }
    }

    public boolean isBlockTransparent(Block block) {
        return this.getBlacklist().contains(block);
    }

    @NetworkEventMeta(direction=EventDirection.S2C)
    public static class MapDataResponseEvent
    extends NetworkEvent {
        public Map<Integer, HeightMapData> maps = Maps.newHashMap();

        protected void readFromStream(PacketBuffer input) {
            int length = input.func_150792_a();
            for (int i = 0; i < length; ++i) {
                int id = input.func_150792_a();
                HeightMapData data = new HeightMapData(id, false);
                data.readFromStream(input);
                this.maps.put(id, data);
            }
        }

        protected void writeToStream(PacketBuffer output) {
            int size = 0;
            for (HeightMapData heightMapData : this.maps.values()) {
                if (!heightMapData.isValid()) continue;
                ++size;
            }
            output.func_150787_b(size);
            for (Map.Entry entry : this.maps.entrySet()) {
                HeightMapData map = (HeightMapData)((Object)entry.getValue());
                if (map.isValid()) {
                    output.func_150787_b(((Integer)entry.getKey()).intValue());
                    map.writeToStream(output);
                    continue;
                }
                Log.debug((String)"Trying to propagate invalid map data %d", (Object[])new Object[]{entry.getKey()});
            }
        }
    }

    @NetworkEventMeta(direction=EventDirection.S2C)
    public static class MapUpdatesEvent
    extends MapIdRequest {
    }

    @NetworkEventMeta(direction=EventDirection.C2S)
    public static class MapDataRequestEvent
    extends MapIdRequest {
    }

    public static abstract class MapIdRequest
    extends NetworkEvent {
        public List<Integer> mapIds = Lists.newArrayList();

        protected void readFromStream(PacketBuffer input) {
            int length = input.func_150792_a();
            for (int i = 0; i < length; ++i) {
                int id = input.func_150792_a();
                this.mapIds.add(id);
            }
        }

        protected void writeToStream(PacketBuffer output) {
            output.func_150787_b(this.mapIds.size());
            for (Integer id : this.mapIds) {
                output.func_150787_b(id.intValue());
            }
        }
    }
}

