/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;

class ModelQuads {
    private final List<BakedQuad> generalQuads;
    private final Map<EnumFacing, List<BakedQuad>> sidedQuads;
    public static final ModelQuads EMPTY;

    private ModelQuads(List<BakedQuad> generalQuads, Map<EnumFacing, List<BakedQuad>> sidedQuads) {
        this.generalQuads = generalQuads;
        this.sidedQuads = sidedQuads;
    }

    public List<BakedQuad> get(@Nullable EnumFacing side) {
        return side != null ? this.sidedQuads.get(side) : this.generalQuads;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        ImmutableMap.Builder emptySides = ImmutableMap.builder();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            emptySides.put((Object)side, (Object)ImmutableList.of());
        }
        EMPTY = new ModelQuads((List)ImmutableList.of(), (Map)emptySides.build()){

            @Override
            public List<BakedQuad> get(@Nullable EnumFacing side) {
                return ImmutableList.of();
            }
        };
    }

    public static class Builder {
        private final List<BakedQuad> generalQuads = Lists.newArrayList();
        private final Map<EnumFacing, List<BakedQuad>> sidedQuads = Maps.newHashMap();

        public Builder() {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.sidedQuads.put(side, Lists.newArrayList());
            }
        }

        public Builder addSidedQuads(EnumFacing side, Collection<BakedQuad> quads) {
            this.sidedQuads.get(side).addAll(quads);
            return this;
        }

        public Builder addGeneralQuads(Collection<BakedQuad> quads) {
            this.generalQuads.addAll(quads);
            return this;
        }

        public Builder merge(ModelQuads other) {
            this.generalQuads.addAll(other.generalQuads);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.sidedQuads.get(side).addAll(other.get(side));
            }
            return this;
        }

        public ModelQuads build() {
            ImmutableMap.Builder sides = ImmutableMap.builder();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                sides.put((Object)side, (Object)ImmutableList.copyOf((Collection)this.sidedQuads.get(side)));
            }
            return new ModelQuads((List)ImmutableList.copyOf(this.generalQuads), (Map)sides.build());
        }
    }
}

