/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorageaddons.apiimpl.network.item;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.item.NetworkItemWirelessGrid;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import com.raoulvdberge.refinedstorageaddons.RSAddons;
import com.raoulvdberge.refinedstorageaddons.item.WirelessCraftingGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class NetworkItemWirelessCraftingGrid
extends NetworkItemWirelessGrid {
    private INetworkItemHandler handler;
    private ItemStack stack;
    private EntityPlayer player;
    private int slotId;

    public NetworkItemWirelessCraftingGrid(INetworkItemHandler handler, EntityPlayer player, ItemStack stack, int slotId) {
        super(handler, player, stack, slotId);
        this.handler = handler;
        this.player = player;
        this.stack = stack;
        this.slotId = slotId;
    }

    public boolean onOpen(INetwork network) {
        if (RSAddons.INSTANCE.config.wirelessCraftingGridUsesEnergy && this.stack.func_77952_i() != 1 && ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() <= RSAddons.INSTANCE.config.wirelessCraftingGridOpenUsage) {
            return false;
        }
        if (!network.getSecurityManager().hasPermission(Permission.MODIFY, this.player)) {
            WorldUtils.sendNoPermissionMessage((EntityPlayer)this.player);
            return false;
        }
        API.instance().getGridManager().openGrid(WirelessCraftingGrid.ID, (EntityPlayerMP)this.player, this.stack, this.slotId);
        this.drainEnergy(RSAddons.INSTANCE.config.wirelessCraftingGridOpenUsage);
        return true;
    }

    public void drainEnergy(int energy) {
        if (RSAddons.INSTANCE.config.wirelessCraftingGridUsesEnergy && this.stack.func_77952_i() != 1) {
            IEnergyStorage energyStorage = (IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null);
            energyStorage.extractEnergy(energy, false);
            if (energyStorage.getEnergyStored() <= 0) {
                this.handler.close(this.getPlayer());
                this.getPlayer().func_71053_j();
            }
        }
    }
}

