/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.monolith;

import net.darkhax.bookshelf.util.ParticleUtils;
import net.darkhax.darkutils.features.monolith.TileEntityMonolith;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileEntityMonolithEXP
extends TileEntityMonolith {
    private static final int MAX_EXP = 1995143615;
    private int storedXP = 0;

    @Override
    public boolean onBlockActivated(World worldIn, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "EXP: " + this.storedXP), true);
            if (playerIn.func_70093_af() && this.storedXP >= 15) {
                playerIn.func_71023_q(15);
                this.storedXP -= 15;
                this.func_70296_d();
            } else if (playerIn.func_184614_ca().func_77973_b() == Items.field_151069_bo && this.storedXP >= 15) {
                playerIn.func_184614_ca().func_190918_g(1);
                playerIn.func_191521_c(new ItemStack(Items.field_151062_by));
                this.storedXP -= 15;
                this.func_70296_d();
            }
        }
        return true;
    }

    @Override
    public void onBlockBroken(World world, BlockPos pos) {
        int extractAmount = Math.max(1, this.storedXP / 6);
        while (this.storedXP > 0 && !world.field_72995_K) {
            int amountToTake = Math.min(this.storedXP, extractAmount);
            this.storedXP -= amountToTake;
            EntityXPOrb xp = new EntityXPOrb(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, amountToTake);
            world.func_72838_d((Entity)xp);
        }
    }

    @Override
    public void onEntityUpdate() {
        boolean hasKilled = false;
        if (this.func_145837_r() || !this.func_145831_w().func_175667_e(this.func_174877_v()) || this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        Chunk chunk = this.func_145831_w().func_175726_f(this.func_174877_v());
        ChunkPos chunkPos = chunk.func_76632_l();
        AxisAlignedBB bounds = new AxisAlignedBB(new BlockPos(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d()), new BlockPos(chunkPos.func_180332_e(), 255, chunkPos.func_180330_f()));
        for (EntityXPOrb orb : this.func_145831_w().func_72872_a(EntityXPOrb.class, bounds)) {
            if (orb.field_70128_L || orb.field_70530_e <= 0) continue;
            orb.field_70530_e = this.consumeXP(orb.field_70530_e);
            if (orb.field_70530_e > 0) continue;
            orb.func_70106_y();
            if (hasKilled) continue;
            BlockPos pos = this.func_174877_v();
            ParticleUtils.spawnParticleRing((World)this.field_145850_b, (EnumParticleTypes)EnumParticleTypes.ENCHANTMENT_TABLE, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.7), (double)((double)pos.func_177952_p() + 0.5), (double)0.0, (double)0.2, (double)0.0, (double)0.25);
            hasKilled = true;
        }
        super.onEntityUpdate();
    }

    public int consumeXP(int exp) {
        int consumed = Math.min(1995143615 - this.storedXP, Math.min(10000, exp));
        this.storedXP += consumed;
        return exp - consumed;
    }

    public int takeXP(int exp) {
        int removed = Math.min(this.storedXP, exp);
        this.storedXP -= removed;
        return removed;
    }

    public void writeNBT(NBTTagCompound dataTag) {
        dataTag.func_74768_a("exp", this.storedXP);
    }

    public void readNBT(NBTTagCompound dataTag) {
        this.storedXP = dataTag.func_74762_e("exp");
    }
}

