/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.monolith;

import net.darkhax.bookshelf.block.BlockTileEntity;
import net.darkhax.bookshelf.registry.IVariant;
import net.darkhax.darkutils.features.monolith.TileEntityMonolith;
import net.darkhax.darkutils.features.monolith.TileEntityMonolithEXP;
import net.darkhax.darkutils.features.monolith.TileEntityMonolithSpawning;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMonolith
extends BlockTileEntity
implements IVariant {
    public static final String[] TYPES = new String[]{"exp", "spawning"};
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    protected BlockMonolith() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149715_a(0.25f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityMonolith) {
            ((TileEntityMonolith)tile).onBlockBroken(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityMonolith) {
            return ((TileEntityMonolith)tile).onBlockActivated(worldIn, playerIn);
        }
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return !TileEntityMonolith.validatePosition(world, pos, false) ? false : super.func_176196_c(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < TYPES.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta == 0) {
            return new TileEntityMonolithEXP();
        }
        if (meta == 1) {
            return new TileEntityMonolithSpawning();
        }
        return null;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static boolean isEnabled(World world, BlockPos pos) {
        return !world.func_175640_z(pos) && world.func_175623_d(pos.func_177984_a());
    }

    public String[] getVariant() {
        return TYPES;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumType implements IStringSerializable
    {
        EXP(0, "exp"),
        SPAWNING(1, "spawning");

        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

