/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.addons.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import net.darkhax.darkutils.features.faketnt.BlockFakeTNT;
import net.darkhax.darkutils.features.filter.BlockFilter;
import net.darkhax.darkutils.features.filter.FilterType;
import net.darkhax.darkutils.features.sneaky.BlockSneaky;
import net.darkhax.darkutils.features.sneaky.TileEntitySneaky;
import net.darkhax.darkutils.features.timer.BlockTimer;
import net.darkhax.darkutils.features.timer.TileEntityTimer;
import net.darkhax.darkutils.features.updatedetector.BlockUpdateDetector;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@WailaPlugin
public class DarkUtilsTileProvider
implements IWailaPlugin,
IWailaDataProvider {
    private static final String CONFIG_FILTER_TYPE = "darkutils.filter.type";
    private static final String CONFIG_TIMER_TIME = "darkutils.timer.time";
    private static final String CONFIG_SNEAKY_OWNERS = "darkutils.sneaky.owner";

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        Block block = Block.func_149634_a((Item)data.getStack().func_77973_b());
        if (block instanceof BlockSneaky && !data.getTileEntity().func_145837_r()) {
            TileEntitySneaky tile = (TileEntitySneaky)data.getTileEntity();
            if (cfg.getConfig(CONFIG_SNEAKY_OWNERS) && tile.playerID != null && !tile.playerID.isEmpty() && data.getPlayer().func_110124_au().toString().equals(tile.playerID)) {
                return data.getStack();
            }
            if (tile.heldState != null) {
                return new ItemStack(tile.heldState.func_177230_c(), 1, tile.heldState.func_177230_c().func_176201_c(tile.heldState));
            }
        } else if (data.getBlock() instanceof BlockFakeTNT) {
            return new ItemStack(Blocks.field_150335_W, 1, 0);
        }
        return new ItemStack(data.getStack().func_77973_b(), 1, 0);
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        if (data.getBlock() instanceof BlockFilter && cfg.getConfig(CONFIG_FILTER_TYPE) && stack.func_77960_j() <= FilterType.getTypes().length) {
            tip.add(I18n.func_135052_a((String)"tooltip.darkutils.filter.type", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + I18n.func_135052_a((String)("tooltip.darkutils.filter.type." + FilterType.getTypes()[stack.func_77960_j()]), (Object[])new Object[0]));
        } else if (data.getBlock() instanceof BlockTimer && cfg.getConfig(CONFIG_TIMER_TIME) && data.getTileEntity() instanceof TileEntityTimer && !data.getTileEntity().func_145837_r()) {
            int delay = data.getNBTData().func_74762_e("TickRate");
            int currentTime = data.getNBTData().func_74762_e("CurrentTime");
            tip.add(I18n.func_135052_a((String)"gui.darkutils.timer.delay", (Object[])new Object[0]) + ": " + delay);
            tip.add(I18n.func_135052_a((String)"gui.darkutils.timer.remaining", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)(delay - currentTime)));
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null && !te.func_145837_r()) {
            te.func_189515_b(tag);
        }
        return tag;
    }

    public void register(IWailaRegistrar register) {
        register.registerStackProvider((IWailaDataProvider)this, BlockUpdateDetector.class);
        register.registerStackProvider((IWailaDataProvider)this, BlockSneaky.class);
        register.registerStackProvider((IWailaDataProvider)this, BlockFakeTNT.class);
        register.registerBodyProvider((IWailaDataProvider)this, BlockFilter.class);
        register.registerBodyProvider((IWailaDataProvider)this, BlockTimer.class);
        register.registerNBTProvider((IWailaDataProvider)this, BlockTimer.class);
        register.registerNBTProvider((IWailaDataProvider)this, BlockSneaky.class);
        register.addConfig("DarkUtils", CONFIG_FILTER_TYPE);
        register.addConfig("DarkUtils", CONFIG_TIMER_TIME);
        register.addConfig("DarkUtils", CONFIG_SNEAKY_OWNERS);
    }
}

