/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.client;

import codechicken.chunkloader.proxy.ProxyClient;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.chunkloader.tile.TileSpotLoader;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;

public class TileChunkLoaderRenderer
extends TileEntitySpecialRenderer<TileChunkLoaderBase> {
    public void render(TileChunkLoaderBase tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        double size;
        double height;
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.setBrightness((IBlockAccess)tile.func_145831_w(), tile.func_174877_v());
        double rot = ClientUtils.getRenderTime() * 2.0;
        double updown = ClientUtils.getRenderTime() % 50.0 / 25.0;
        updown = (float)Math.sin(updown * 3.141593);
        updown *= 0.2;
        if (tile instanceof TileChunkLoader) {
            TileChunkLoader ctile = (TileChunkLoader)tile;
            rot /= Math.pow(ctile.radius, 0.2);
            height = 0.9;
            size = 0.08;
        } else if (tile instanceof TileSpotLoader) {
            height = 0.5;
            size = 0.05;
        } else {
            return;
        }
        RenderInfo renderInfo = tile.renderInfo;
        double active = (double)renderInfo.activationCounter / 20.0;
        if (tile.active && renderInfo.activationCounter < 20) {
            active += (double)partialTicks / 20.0;
        } else if (!tile.active && renderInfo.activationCounter > 0) {
            active -= (double)partialTicks / 20.0;
        }
        if (renderInfo.showLasers) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            this.drawRays(x, y, z, rot, updown, tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), tile.getChunks());
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179127_m();
        }
        rot = ClientUtils.getRenderTime() * active / 3.0;
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + height + (updown + 0.3) * active, z + 0.5), (Rotation)new Rotation(rot, new Vector3(0.0, 1.0, 0.0)), (double)size);
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        TextureUtils.changeTexture((String)"chickenchunks:textures/hedronmap.png");
        ccrs.startDrawing(7, DefaultVertexFormats.field_181712_l);
        CCModelLibrary.icosahedron7.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.draw();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    public Point2D.Double findIntersection(Line2D line1, Line2D line2) {
        double xD1 = line1.getX2() - line1.getX1();
        double yD1 = line1.getY2() - line1.getY1();
        double xD2 = line2.getX2() - line2.getX1();
        double yD2 = line2.getY2() - line2.getY1();
        double xD3 = line1.getX1() - line2.getX1();
        double yD3 = line1.getY1() - line2.getY1();
        Point2D.Double pt = new Point2D.Double(0.0, 0.0);
        double div = yD2 * xD1 - xD2 * yD1;
        if (div == 0.0) {
            return null;
        }
        double ua = (xD2 * yD3 - yD2 * xD3) / div;
        pt.x = line1.getX1() + ua * xD1;
        pt.y = line1.getY1() + ua * yD1;
        if (this.ptOnLineInSegment(pt, line1) && this.ptOnLineInSegment(pt, line2)) {
            return pt;
        }
        return null;
    }

    public boolean ptOnLineInSegment(Point2D point, Line2D line) {
        return point.getX() >= Math.min(line.getX1(), line.getX2()) && point.getX() <= Math.max(line.getX1(), line.getX2()) && point.getY() >= Math.min(line.getY1(), line.getY2()) && point.getY() <= Math.max(line.getY1(), line.getY2());
    }

    public void drawRays(double d, double d1, double d2, double rotationAngle, double updown, int x, int y, int z, Collection<ChunkPos> chunkSet) {
        int ray;
        int cx = x >> 4 << 4;
        int cz = z >> 4 << 4;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(d + (double)cx - (double)x + 8.0), (double)(d1 + updown + 2.0), (double)(d2 + (double)cz - (double)z + 8.0));
        GlStateManager.func_179114_b((float)((float)rotationAngle), (float)0.0f, (float)1.0f, (float)0.0f);
        double[] distances = new double[4];
        Point2D.Double center = new Point2D.Double(cx + 8, cz + 8);
        int[][] coords = new int[][]{{0, 0}, {16, 0}, {16, 16}, {0, 16}};
        Point2D.Double[] absRays = new Point2D.Double[4];
        for (int ray2 = 0; ray2 < 4; ++ray2) {
            double rayAngle = Math.toRadians(rotationAngle + (double)(90 * ray2));
            absRays[ray2] = new Point2D.Double(Math.sin(rayAngle), Math.cos(rayAngle));
        }
        Line2D.Double[] rays = new Line2D.Double[]{new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[0].x, center.y + 1600.0 * absRays[0].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[1].x, center.y + 1600.0 * absRays[1].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[2].x, center.y + 1600.0 * absRays[2].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[3].x, center.y + 1600.0 * absRays[3].y)};
        for (ChunkPos pair : chunkSet) {
            int chunkBlockX = pair.field_77276_a << 4;
            int chunkBlockZ = pair.field_77275_b << 4;
            for (int side = 0; side < 4; ++side) {
                int[] offset1 = coords[side];
                int[] offset2 = coords[(side + 1) % 4];
                Line2D.Double line1 = new Line2D.Double(chunkBlockX + offset1[0], chunkBlockZ + offset1[1], chunkBlockX + offset2[0], chunkBlockZ + offset2[1]);
                for (int ray3 = 0; ray3 < 4; ++ray3) {
                    Point2D.Double isct = this.findIntersection(line1, rays[ray3]);
                    if (isct == null) continue;
                    isct.setLocation(isct.x - center.x, isct.y - center.y);
                    double lenPow2 = isct.x * isct.x + isct.y * isct.y;
                    if (!(lenPow2 > distances[ray3])) continue;
                    distances[ray3] = lenPow2;
                }
            }
        }
        GlStateManager.func_179131_c((float)0.9f, (float)0.0f, (float)0.0f, (float)1.0f);
        for (ray = 0; ray < 4; ++ray) {
            distances[ray] = Math.sqrt(distances[ray]);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            TileChunkLoaderRenderer.renderCuboid(new Cuboid6(0.0, -0.05, -0.05, distances[ray], 0.05, 0.05));
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(d + (double)cx - (double)x + 8.0), (double)(d1 - (double)y), (double)(d2 + (double)cz - (double)z + 8.0));
        for (ray = 0; ray < 4; ++ray) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(absRays[ray].x * distances[ray]), (double)0.0, (double)(absRays[ray].y * distances[ray]));
            TileChunkLoaderRenderer.renderCuboid(new Cuboid6(-0.05, 0.0, -0.05, 0.05, 256.0, 0.05));
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        double toCenter = Math.sqrt(((double)cx + 7.5 - (double)x) * ((double)cx + 7.5 - (double)x) + 0.6400000000000001 + ((double)cz + 7.5 - (double)z) * ((double)cz + 7.5 - (double)z));
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)0.0f, (float)0.9f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(d + 0.5), (double)(d1 + 1.2 + updown), (double)(d2 + 0.5));
        GlStateManager.func_179114_b((float)((float)(Math.atan2((double)cx + 7.5 - (double)x, (double)cz + 7.5 - (double)z) * 180.0 / 3.1415) + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(-Math.asin(0.8 / toCenter) * 180.0 / 3.1415)), (float)0.0f, (float)0.0f, (float)1.0f);
        TileChunkLoaderRenderer.renderCuboid(new Cuboid6(-toCenter, -0.03, -0.03, 0.0, 0.03, 0.03));
        GlStateManager.func_179121_F();
    }

    private static void renderCuboid(Cuboid6 cuboid) {
        if (ProxyClient.lasersRenderHollow) {
            RenderUtils.drawCuboidOutline((Cuboid6)cuboid);
        } else {
            RenderUtils.drawCuboidSolid((Cuboid6)cuboid);
        }
    }

    public static class RenderInfo {
        public int activationCounter;
        public boolean showLasers;

        public void update(TileChunkLoaderBase chunkLoader) {
            if (this.activationCounter < 20 && chunkLoader.active) {
                ++this.activationCounter;
            } else if (this.activationCounter > 0 && !chunkLoader.active) {
                --this.activationCounter;
            }
        }
    }
}

