/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.handler.event;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.block.BlockAltar;
import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.entity.mob.EntitySentientSpecter;
import WayofTime.bloodmagic.event.ItemBindEvent;
import WayofTime.bloodmagic.event.SacrificeKnifeUsedEvent;
import WayofTime.bloodmagic.event.TeleposeEvent;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.iface.ISentientTool;
import WayofTime.bloodmagic.item.ItemAltarMaker;
import WayofTime.bloodmagic.item.ItemExperienceBook;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.item.gear.ItemPackSacrifice;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeBattleHungry;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerSelfSacrifice;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeSelfSacrifice;
import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.network.DemonAuraPacketProcessor;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.potion.BMPotionUtils;
import WayofTime.bloodmagic.potion.PotionEventHandlers;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.RitualManager;
import WayofTime.bloodmagic.ritual.types.RitualVeilOfEvil;
import WayofTime.bloodmagic.ritual.types.RitualWardOfSacrosanctity;
import WayofTime.bloodmagic.soul.DemonWillHolder;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.BindableHelper;
import WayofTime.bloodmagic.util.helper.ItemHelper;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod.EventBusSubscriber(modid="bloodmagic")
public class GenericHandler {
    public static Map<World, Map<EntityPlayer, Double>> bounceMapMap = new HashMap<World, Map<EntityPlayer, Double>>();
    public static Map<World, Map<EntityPlayer, Integer>> filledHandMapMap = new HashMap<World, Map<EntityPlayer, Integer>>();
    private static Map<World, Map<EntityAnimal, EntityAITarget>> targetTaskMapMap = new HashMap<World, Map<EntityAnimal, EntityAITarget>>();
    private static Map<World, Map<EntityAnimal, EntityAIBase>> attackTaskMapMap = new HashMap<World, Map<EntityAnimal, EntityAIBase>>();
    public static Map<World, Map<IMasterRitualStone, AreaDescriptor>> preventSpawnMap = new HashMap<World, Map<IMasterRitualStone, AreaDescriptor>>();
    public static Map<World, Map<IMasterRitualStone, AreaDescriptor>> forceSpawnMap = new HashMap<World, Map<IMasterRitualStone, AreaDescriptor>>();
    public static Set<IMasterRitualStone> featherRitualSet;

    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).func_70644_a(RegistrarBloodMagic.BOUNCE) && !player.func_70093_af() && event.getDistance() > 2.0f) {
            event.setDamageMultiplier(0.0f);
            if (player.func_130014_f_().field_72995_K) {
                player.field_70181_x *= -0.9;
                player.field_70143_R = 0.0f;
                bounceMapMap.get(player.func_130014_f_()).put(player, player.field_70181_x);
            } else {
                player.field_70143_R = 0.0f;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerTickPost(TickEvent.PlayerTickEvent event) {
        World world = event.player.func_130014_f_();
        Map<EntityPlayer, Double> bounceMap = bounceMapMap.get(world);
        if (event.phase == TickEvent.Phase.END && bounceMap.containsKey(event.player)) {
            event.player.field_70181_x = bounceMap.remove(event.player);
        }
        Map<EntityPlayer, Integer> filledHandMap = filledHandMapMap.get(world);
        if (event.phase == TickEvent.Phase.END && filledHandMap.containsKey(event.player)) {
            int value = filledHandMap.get(event.player) - 1;
            if (value <= 0) {
                filledHandMap.remove(event.player);
            } else {
                filledHandMap.put(event.player, value);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClick(PlayerInteractEvent event) {
        if (event.isCancelable() && event.getEntityPlayer().func_70644_a(RegistrarBloodMagic.CONSTRICT)) {
            EntityPlayer player = event.getEntityPlayer();
            int level = player.func_70660_b(RegistrarBloodMagic.CONSTRICT).func_76458_c();
            if (event.getHand() == EnumHand.OFF_HAND || level > 1) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDropItem(ItemTossEvent event) {
        EntityItem itemEntity = event.getEntityItem();
        if (itemEntity != null) {
            ItemStack stack = itemEntity.func_92059_d();
            Item item = stack.func_77973_b();
            if (stack.func_77942_o() && item instanceof ISentientTool && ((ISentientTool)item).spawnSentientEntityOnDrop(stack, event.getPlayer())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start event) {
        World world = event.getWorld();
        Explosion exp = event.getExplosion();
        Vec3d position = exp.getPosition();
        double radius = 3.0;
        AxisAlignedBB bb = new AxisAlignedBB(position.field_72450_a - radius, position.field_72448_b - radius, position.field_72449_c - radius, position.field_72450_a + radius, position.field_72448_b + radius, position.field_72449_c + radius);
        List specterList = world.func_72872_a(EntitySentientSpecter.class, bb);
        if (!specterList.isEmpty()) {
            for (EntitySentientSpecter specter : specterList) {
                if (!specter.absorbExplosion(exp)) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !PlayerHelper.isFakePlayer((EntityPlayer)event.getSource().func_76346_g())) {
            LivingArmourUpgrade upgrade;
            ItemStack chestStack;
            LivingArmour armour;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (!player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemPackSacrifice) {
                ItemPackSacrifice pack = (ItemPackSacrifice)player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b();
                boolean shouldSyphon = pack.getStoredLP(player.func_184582_a(EntityEquipmentSlot.CHEST)) < pack.CAPACITY;
                float damageDone = event.getEntityLiving().func_110143_aJ() < event.getAmount() ? event.getAmount() - event.getEntityLiving().func_110143_aJ() : event.getAmount();
                int totalLP = Math.round(damageDone * (float)ConfigHandler.values.coatOfArmsConversion);
                if (shouldSyphon) {
                    ItemHelper.LPContainer.addLPToItem(player.func_184582_a(EntityEquipmentSlot.CHEST), totalLP, pack.CAPACITY);
                }
            }
            if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null && (upgrade = ItemLivingArmour.getUpgrade("bloodmagic.upgrade.battleHunger", chestStack)) instanceof LivingArmourUpgradeBattleHungry) {
                ((LivingArmourUpgradeBattleHungry)upgrade).resetTimer();
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        int duration;
        EntityPlayer player;
        EntityLivingBase entity;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
            entity = event.getEntityLiving();
            if (entity instanceof EntityPlayer && entity.field_70173_aa % 50 == 0) {
                GenericHandler.sendPlayerDemonWillAura((EntityPlayer)entity);
            }
            World world = entity.func_130014_f_();
            Map<EntityAnimal, EntityAITarget> targetTaskMap = targetTaskMapMap.get(world);
            Map<EntityAnimal, EntityAIBase> attackTaskMap = attackTaskMapMap.get(world);
            if (event.getEntityLiving() instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)event.getEntityLiving();
                if (animal.func_70644_a(RegistrarBloodMagic.SACRIFICIAL_LAMB)) {
                    if (!targetTaskMap.containsKey(animal)) {
                        EntityAINearestAttackableTarget task = new EntityAINearestAttackableTarget((EntityCreature)animal, EntityMob.class, false);
                        EntityAIAttackMelee attackTask = new EntityAIAttackMelee((EntityCreature)animal, 1.0, false);
                        animal.field_70715_bh.func_75776_a(1, (EntityAIBase)task);
                        animal.field_70714_bg.func_75776_a(1, (EntityAIBase)attackTask);
                        targetTaskMap.put(animal, (EntityAITarget)task);
                        attackTaskMap.put(animal, (EntityAIBase)attackTask);
                    }
                    if (animal.func_70638_az() != null && animal.func_70068_e((Entity)animal.func_70638_az()) < 4.0) {
                        animal.func_130014_f_().func_72876_a(null, animal.field_70165_t, animal.field_70163_u + (double)(animal.field_70131_O / 16.0f), animal.field_70161_v, 2.0f + (float)animal.func_70660_b(RegistrarBloodMagic.SACRIFICIAL_LAMB).func_76458_c() * 1.5f, false);
                        targetTaskMap.remove(animal);
                        attackTaskMap.remove(animal);
                    }
                } else {
                    if (targetTaskMap != null) {
                        targetTaskMap.remove(animal);
                    }
                    if (attackTaskMap != null) {
                        attackTaskMap.remove(animal);
                    }
                }
            }
        }
        if ((entity = event.getEntityLiving()) instanceof EntityPlayer && (player = (EntityPlayer)entity).func_70093_af() && player.func_70644_a(RegistrarBloodMagic.CLING) && Utils.isPlayerBesideSolidBlockFace(player) && !player.field_70122_E) {
            if (player.func_130014_f_().field_72995_K) {
                player.field_70181_x = 0.0;
                player.field_70159_w *= 0.8;
                player.field_70179_y *= 0.8;
            } else {
                player.field_70143_R = 0.0f;
            }
        }
        if (entity.func_70644_a(MobEffects.field_76439_r) && (duration = entity.func_70660_b(MobEffects.field_76439_r).func_76459_b()) == 30000) {
            entity.func_184589_d(MobEffects.field_76439_r);
        }
        if (entity.func_70644_a(RegistrarBloodMagic.FIRE_FUSE)) {
            Random random = entity.func_130014_f_().field_73012_v;
            entity.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, entity.field_70165_t + random.nextDouble() * 0.3, entity.field_70163_u + random.nextDouble() * 0.3, entity.field_70161_v + random.nextDouble() * 0.3, 0.0, 0.06, 0.0, new int[0]);
            int r = entity.func_70660_b(RegistrarBloodMagic.FIRE_FUSE).func_76458_c();
            int radius = r + 1;
            if (entity.func_70660_b(RegistrarBloodMagic.FIRE_FUSE).func_76459_b() <= 3) {
                entity.func_130014_f_().func_72876_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (float)radius, false);
            }
        }
        if (entity.func_70644_a(RegistrarBloodMagic.PLANT_LEECH)) {
            int amplifier = entity.func_70660_b(RegistrarBloodMagic.PLANT_LEECH).func_76458_c();
            int timeRemaining = entity.func_70660_b(RegistrarBloodMagic.PLANT_LEECH).func_76459_b();
            if (timeRemaining % 10 == 0) {
                BMPotionUtils.damageMobAndGrowSurroundingPlants(entity, 2 + amplifier, 1, 1.5 / (double)(amplifier + 3), 25 * (1 + amplifier));
            }
        }
    }

    public static void sendPlayerDemonWillAura(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            BlockPos pos = player.func_180425_c();
            DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(player.func_130014_f_().field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            if (holder != null) {
                BloodMagicPacketHandler.sendTo(new DemonAuraPacketProcessor(holder), (EntityPlayerMP)player);
            } else {
                BloodMagicPacketHandler.sendTo(new DemonAuraPacketProcessor(new DemonWillHolder()), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public static void harvestEvent(PlayerEvent.HarvestCheck event) {
        IBlockState state = event.getTargetBlock();
        Block block = state.func_177230_c();
        if (block instanceof BlockAltar && event.getEntityPlayer() != null && event.getEntityPlayer() instanceof EntityPlayerMP && !event.getEntityPlayer().func_184614_ca().func_190926_b() && event.getEntityPlayer().func_184614_ca().func_77973_b() instanceof ItemAltarMaker) {
            ItemAltarMaker altarMaker = (ItemAltarMaker)event.getEntityPlayer().func_184614_ca().func_77973_b();
            event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.altarMaker.destroy", new Object[]{altarMaker.destroyAltar(event.getEntityPlayer())}), true);
        }
    }

    @SubscribeEvent
    public static void onTelepose(TeleposeEvent event) {
        if (BloodMagicAPI.INSTANCE.getBlacklist().getTeleposer().contains(event.initialState) || BloodMagicAPI.INSTANCE.getBlacklist().getTeleposer().contains(event.finalState)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTeleposeEntity(TeleposeEvent.Ent event) {
        EntityEntry entry = EntityRegistry.getEntry(event.entity.getClass());
        if (entry != null && BloodMagicAPI.INSTANCE.getBlacklist().getTeleposerEntities().contains(entry.getRegistryName())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTeleposeEntityPost(TeleposeEvent.Ent.Post event) {
        event.entity.field_71088_bW = 5;
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.func_190926_b() && held.func_77973_b() instanceof IBindable) {
            IBindable bindable = (IBindable)held.func_77973_b();
            Binding binding = bindable.getBinding(held);
            if (binding == null) {
                if (bindable.onBind(player, held)) {
                    ItemBindEvent toPost = new ItemBindEvent(player, held);
                    if (MinecraftForge.EVENT_BUS.post((Event)toPost)) {
                        return;
                    }
                    BindableHelper.applyBinding(held, player);
                }
            } else if (binding.getOwnerId().equals(player.func_146103_bH().getId()) && !binding.getOwnerName().equals(player.func_146103_bH().getName())) {
                binding.setOwnerName(player.func_146103_bH().getName());
                BindableHelper.applyBinding(held, binding);
            }
        }
        if (!held.func_190926_b() && held.func_77973_b() instanceof IBloodOrb) {
            IBloodOrb bloodOrb = (IBloodOrb)held.func_77973_b();
            SoulNetwork network = NetworkHelper.getSoulNetwork(player);
            BloodOrb orb = bloodOrb.getOrb(held);
            if (orb == null) {
                return;
            }
            if (orb.getTier() > network.getOrbTier()) {
                network.setOrbTier(orb.getTier());
            }
        }
    }

    @SubscribeEvent
    public static void selfSacrificeEvent(SacrificeKnifeUsedEvent event) {
        ItemStack chestStack;
        LivingArmour armour;
        EntityPlayer player = event.player;
        if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null) {
            StatTrackerSelfSacrifice.incrementCounter(armour, event.healthDrained / 2);
            LivingArmourUpgrade upgrade = ItemLivingArmour.getUpgrade("bloodmagic.upgrade.selfSacrifice", chestStack);
            if (upgrade instanceof LivingArmourUpgradeSelfSacrifice) {
                double modifier = ((LivingArmourUpgradeSelfSacrifice)upgrade).getSacrificeModifier();
                event.lpAdded = (int)((double)event.lpAdded * (1.0 + modifier));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        EntityPlayer player;
        ItemStack heldStack;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer && !(heldStack = (player = (EntityPlayer)entity).func_184614_ca()).func_190926_b() && heldStack.func_77973_b() == RegistrarBloodMagicItems.BOUND_SWORD && !(attackedEntity instanceof EntityAnimal)) {
            for (int i = 0; i <= EnchantmentHelper.func_185283_h((EntityLivingBase)player); ++i) {
                if (!(attackedEntity.func_130014_f_().field_73012_v.nextDouble() < 0.2)) continue;
                event.getDrops().add(new EntityItem(attackedEntity.func_130014_f_(), attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, new ItemStack(RegistrarBloodMagicItems.BLOOD_SHARD, 1, 0)));
            }
        }
    }

    @SubscribeEvent
    public static void onRitualDeath(LivingDropsEvent event) {
        if (!ConfigHandler.values.wellOfSufferingDrops && event.getSource().equals(RitualManager.RITUAL_DAMAGE)) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onExperiencePickup(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player);
        if (!Loader.isModLoaded((String)"unmending") && !itemstack.func_190926_b() && itemstack.func_77951_h()) {
            int i = Math.min(GenericHandler.xpToDurability(event.getOrb().field_70530_e), itemstack.func_77952_i());
            event.getOrb().field_70530_e -= GenericHandler.durabilityToXp(i);
            itemstack.func_77964_b(itemstack.func_77952_i() - i);
        }
        if (!player.func_130014_f_().field_72995_K) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!(stack.func_77973_b() instanceof ItemExperienceBook)) continue;
                ItemExperienceBook.addExperience(stack, event.getOrb().field_70530_e);
                event.getOrb().field_70530_e = 0;
                break;
            }
        }
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    @SubscribeEvent
    public static void onLivingSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        Map<IMasterRitualStone, AreaDescriptor> fMap;
        AreaDescriptor blockRange;
        IMasterRitualStone masterRitualStone;
        Map<IMasterRitualStone, AreaDescriptor> pMap;
        World world = event.getWorld();
        if (!(event.getEntityLiving() instanceof EntityMob)) {
            return;
        }
        if (preventSpawnMap.containsKey(world) && (pMap = preventSpawnMap.get(world)) != null) {
            for (Map.Entry<IMasterRitualStone, AreaDescriptor> entry : pMap.entrySet()) {
                masterRitualStone = entry.getKey();
                blockRange = entry.getValue();
                if (masterRitualStone != null && masterRitualStone.isActive() && masterRitualStone.getCurrentRitual() instanceof RitualWardOfSacrosanctity) {
                    if (!blockRange.offset(masterRitualStone.getBlockPos()).isWithinArea(new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ()))) continue;
                    switch (event.getResult()) {
                        case ALLOW: {
                            event.setResult(Event.Result.DEFAULT);
                            break;
                        }
                        case DEFAULT: {
                            event.setResult(Event.Result.DENY);
                            break;
                        }
                    }
                    break;
                }
                pMap.remove(masterRitualStone);
            }
        }
        if (forceSpawnMap.containsKey(world) && (fMap = forceSpawnMap.get(world)) != null) {
            for (Map.Entry<IMasterRitualStone, AreaDescriptor> entry : fMap.entrySet()) {
                masterRitualStone = entry.getKey();
                blockRange = entry.getValue();
                if (masterRitualStone != null && masterRitualStone.isActive() && masterRitualStone.getCurrentRitual() instanceof RitualVeilOfEvil) {
                    if (!blockRange.offset(masterRitualStone.getBlockPos()).isWithinArea(new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ()))) continue;
                    switch (event.getResult()) {
                        case DEFAULT: {
                            event.setResult(Event.Result.ALLOW);
                            break;
                        }
                        case DENY: {
                            event.setResult(Event.Result.DEFAULT);
                        }
                    }
                    break;
                }
                fMap.remove(masterRitualStone);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        bounceMapMap.computeIfAbsent(world, k -> new HashMap());
        filledHandMapMap.computeIfAbsent(world, k -> new HashMap());
        attackTaskMapMap.computeIfAbsent(world, k -> new HashMap());
        targetTaskMapMap.computeIfAbsent(world, k -> new HashMap());
        forceSpawnMap.computeIfAbsent(world, k -> new HashMap());
        preventSpawnMap.computeIfAbsent(world, k -> new HashMap());
        PotionEventHandlers.flightListMap.computeIfAbsent(world, k -> new ArrayList());
        PotionEventHandlers.noGravityListMap.computeIfAbsent(world, k -> new ArrayList());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        bounceMapMap.remove(world);
        filledHandMapMap.remove(world);
        attackTaskMapMap.remove(world);
        targetTaskMapMap.remove(world);
        PotionEventHandlers.flightListMap.remove(world);
        PotionEventHandlers.noGravityListMap.remove(world);
    }
}

