/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.tile.base.TileTicking;
import com.google.common.base.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileSpectralBlock
extends TileTicking {
    private int ticksRemaining;
    private String containedBlockName;
    private int containedBlockMeta;

    @Override
    public void deserialize(NBTTagCompound tagCompound) {
        this.ticksRemaining = tagCompound.func_74762_e("ticksRemaining");
        this.containedBlockName = tagCompound.func_74779_i("containedBlockName");
        this.containedBlockMeta = tagCompound.func_74762_e("containedBlockMeta");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("ticksRemaining", this.ticksRemaining);
        tagCompound.func_74778_a("containedBlockName", Strings.isNullOrEmpty((String)this.containedBlockName) ? "" : this.containedBlockName);
        tagCompound.func_74768_a("containedBlockMeta", this.containedBlockMeta);
        return tagCompound;
    }

    @Override
    public void onUpdate() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        --this.ticksRemaining;
        if (this.ticksRemaining <= 0) {
            this.returnContainedBlock();
        }
    }

    private void setContainedBlockInfo(IBlockState blockState) {
        this.containedBlockName = blockState.func_177230_c().getRegistryName().toString();
        this.containedBlockMeta = blockState.func_177230_c().func_176201_c(blockState);
    }

    private void setDuration(int duration) {
        this.ticksRemaining = duration;
    }

    public void resetDuration(int reset) {
        if (this.ticksRemaining < reset) {
            this.ticksRemaining = reset;
        }
    }

    public void returnContainedBlock() {
        Block block = null;
        if (!Strings.isNullOrEmpty((String)this.containedBlockName)) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.containedBlockName));
        }
        if (block != null && this.func_145831_w().func_175656_a(this.field_174879_c, block.func_176203_a(this.containedBlockMeta))) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
    }

    public static void createSpectralBlock(World world, BlockPos blockPos, int duration) {
        if (world.func_175623_d(blockPos)) {
            return;
        }
        IBlockState cachedState = world.func_180495_p(blockPos);
        world.func_175656_a(blockPos, RegistrarBloodMagicBlocks.SPECTRAL.func_176223_P());
        TileSpectralBlock tile = (TileSpectralBlock)world.func_175625_s(blockPos);
        tile.setContainedBlockInfo(cachedState);
        tile.setDuration(duration);
    }
}

