/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TartaricForgeRecipe {
    protected ItemStack output = null;
    protected List<Object> input = new ArrayList<Object>();
    protected double minimumSouls;
    protected double soulsDrained;

    public TartaricForgeRecipe(Block result, double minSouls, double drain, Object ... recipe) {
        this(new ItemStack(result), minSouls, drain, recipe);
    }

    public TartaricForgeRecipe(Item result, double minSouls, double drain, Object ... recipe) {
        this(new ItemStack(result), minSouls, drain, recipe);
    }

    public TartaricForgeRecipe(ItemStack result, double minSouls, double drain, Object ... recipe) {
        this.output = result.func_77946_l();
        this.minimumSouls = minSouls;
        this.soulsDrained = drain;
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            StringBuilder ret = new StringBuilder("Invalid soul forge recipe: ");
            for (Object tmp : recipe) {
                ret.append(tmp).append(", ");
            }
            ret.append(this.output);
            throw new RuntimeException(ret.toString());
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public ItemStack getRecipeOutput() {
        return this.output.func_77946_l();
    }

    public boolean matches(List<ItemStack> checkedList, World world, BlockPos pos) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (ItemStack slot : checkedList) {
            if (slot == null) continue;
            boolean inRecipe = false;
            for (Object aRequired : required) {
                boolean match = false;
                if (aRequired instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)aRequired), (ItemStack)slot, (boolean)false);
                } else if (aRequired instanceof List) {
                    Iterator itr = ((List)aRequired).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(aRequired);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public List<Object> getInput() {
        return this.input;
    }

    public double getMinimumSouls() {
        return this.minimumSouls;
    }

    public double getSoulsDrained() {
        return this.soulsDrained;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("output", (Object)this.output).append("input", this.input).append("minimumSouls", this.minimumSouls).append("soulsDrained", this.soulsDrained).append("recipeSize", this.getRecipeSize()).append("recipeOutput", (Object)this.getRecipeOutput()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TartaricForgeRecipe)) {
            return false;
        }
        TartaricForgeRecipe that = (TartaricForgeRecipe)o;
        if (Double.compare(that.minimumSouls, this.minimumSouls) != 0) {
            return false;
        }
        if (Double.compare(that.soulsDrained, this.soulsDrained) != 0) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        return this.input != null ? this.input.equals(that.input) : that.input == null;
    }

    public int hashCode() {
        int result = this.output != null ? this.output.hashCode() : 0;
        result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.minimumSouls);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.soulsDrained);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

