/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.routing;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.item.inventory.ItemInventory;
import WayofTime.bloodmagic.item.routing.IFluidFilterProvider;
import WayofTime.bloodmagic.routing.IFluidFilter;
import WayofTime.bloodmagic.routing.RoutingFluidFilter;
import WayofTime.bloodmagic.util.GhostItemHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidRouterFilter
extends Item
implements IFluidFilterProvider,
IVariantProvider {
    public static String[] names = new String[]{"exact"};

    public ItemFluidRouterFilter() {
        this.func_77655_b("bloodmagic.fluidFilter.");
        this.func_77627_a(true);
        this.func_77637_a(BloodMagic.TAB_BM);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names[stack.func_77952_i()];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            list.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextHelper.localize("tooltip.bloodmagic.fluidFilter." + names[stack.func_77952_i()], new Object[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public IFluidFilter getInputFluidFilter(ItemStack filterStack, TileEntity tile, IFluidHandler handler) {
        RoutingFluidFilter testFilter;
        switch (filterStack.func_77960_j()) {
            case 0: {
                testFilter = new RoutingFluidFilter();
                break;
            }
            default: {
                testFilter = new RoutingFluidFilter();
            }
        }
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>();
        ItemInventory inv = new ItemInventory(filterStack, 9, "");
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemStack ghostStack = GhostItemHelper.getStackFromGhost(stack);
            filteredList.add(ghostStack);
        }
        testFilter.initializeFilter(filteredList, tile, handler, false);
        return testFilter;
    }

    @Override
    public IFluidFilter getOutputFluidFilter(ItemStack filterStack, TileEntity tile, IFluidHandler handler) {
        RoutingFluidFilter testFilter;
        switch (filterStack.func_77960_j()) {
            case 0: {
                testFilter = new RoutingFluidFilter();
                break;
            }
            default: {
                testFilter = new RoutingFluidFilter();
            }
        }
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>();
        ItemInventory inv = new ItemInventory(filterStack, 9, "");
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemStack ghostStack = GhostItemHelper.getStackFromGhost(stack);
            if (ghostStack.func_190926_b()) {
                ghostStack.func_190920_e(Integer.MAX_VALUE);
            }
            filteredList.add(ghostStack);
        }
        testFilter.initializeFilter(filteredList, tile, handler, true);
        return testFilter;
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=exact");
    }

    @Override
    public ItemStack getContainedStackForItem(ItemStack filterStack, ItemStack keyStack) {
        ItemStack copyStack = keyStack.func_77946_l();
        GhostItemHelper.setItemGhostAmount(copyStack, 0);
        copyStack.func_190920_e(1);
        return copyStack;
    }
}

