/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.alchemy;

import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.iface.ICustomAlchemyConsumable;
import WayofTime.bloodmagic.item.ItemEnum;
import WayofTime.bloodmagic.item.types.ISubItem;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCuttingFluid
extends ItemEnum.Variant<FluidType>
implements ICustomAlchemyConsumable {
    public ItemCuttingFluid() {
        super(FluidType.class, "cutting_fluid");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        int max = this.getMaxUsesForFluid(stack);
        tooltip.add(TextHelper.localize("tooltip.bloodmagic.cuttingFluidRatio", max - this.getDamageOfFluid(stack), max));
    }

    public int getDamageOfFluid(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74762_e("used");
    }

    public void applyDamageToFluid(ItemStack stack) {
        int damage = Math.min(this.getDamageOfFluid(stack) + 1, this.getMaxUsesForFluid(stack));
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74768_a("used", damage);
    }

    public int getMaxUsesForFluid(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 16;
            }
            case 1: {
                return 64;
            }
        }
        return 1;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamageOfFluid(stack) / (double)this.getMaxUsesForFluid(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDamageOfFluid(stack) > 0;
    }

    @Override
    public ItemStack drainUseOnAlchemyCraft(ItemStack stack) {
        this.applyDamageToFluid(stack);
        if (this.getDamageOfFluid(stack) >= this.getMaxUsesForFluid(stack)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static enum FluidType implements ISubItem
    {
        BASIC,
        EXPLOSIVE;


        @Override
        @Nonnull
        public String getInternalName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        @Nonnull
        public ItemStack getStack(int count) {
            return new ItemStack(RegistrarBloodMagicItems.CUTTING_FLUID, count, this.ordinal());
        }
    }
}

