/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.command.sub;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import WayofTime.bloodmagic.util.helper.RitualHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;

public class SubCommandRitual
extends CommandTreeBase {
    public SubCommandRitual() {
        this.addSubcommand((ICommand)new RitualCreate());
        this.addSubcommand((ICommand)new RitualRepair());
        this.addSubcommand((ICommand)new CommandTreeHelp((CommandTreeBase)this));
    }

    public String func_71517_b() {
        return "ritual";
    }

    public String func_71518_a(ICommandSender sender) {
        return null;
    }

    public TileMasterRitualStone getMRS(ICommandSender sender) {
        BlockPos pos = sender.func_180425_c().func_177977_b();
        World world = sender.func_130014_f_();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone) {
            return (TileMasterRitualStone)tile;
        }
        return null;
    }

    public int func_82362_a() {
        return 2;
    }

    class RitualRepair
    extends CommandTreeBase {
        RitualRepair() {
        }

        public String func_71517_b() {
            return "repair";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.bloodmagic.ritual.repair.usage";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String ... args) throws CommandException {
            EntityPlayerMP player = args.length < 2 ? RitualRepair.func_71521_c((ICommandSender)sender) : RitualRepair.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            TileMasterRitualStone tile = SubCommandRitual.this.getMRS((ICommandSender)player);
            boolean safe = false;
            if (args.length > 0 && args.length < 3) {
                int k = args.length - 1;
                if (args[k].equals("true") || args[k].equals("false")) {
                    safe = Boolean.parseBoolean(args[k]);
                } else if (args[0].equals("safe")) {
                    safe = true;
                }
            }
            if (tile != null) {
                if (RitualHelper.repairRitualFromRuins(tile, safe)) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.success", new Object[0]));
                } else if (!safe) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.ritual.create.error.outOfWorldBoundaries", new Object[0]));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.ritaul.create.error.unsafe", new Object[0]));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.ritual.error.noMRS", new Object[0]));
            }
        }
    }

    class RitualCreate
    extends CommandTreeBase {
        public List<String> ritualList = new ArrayList<String>();

        public RitualCreate() {
            for (Ritual ritual : BloodMagic.RITUAL_MANAGER.getRituals()) {
                this.ritualList.add(BloodMagic.RITUAL_MANAGER.getId(ritual));
            }
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return this.ritualList;
        }

        public String func_71517_b() {
            return "create";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String ... args) throws CommandException {
            EnumFacing direction;
            if (args.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.blooodmagic.ritual.create.noRitual", new Object[0]));
                return;
            }
            if (args.length == 2 && (args[1].equals("help") || args[1].equals("?"))) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(BloodMagic.RITUAL_MANAGER.getRitual(args[0]).getTranslationKey() + ".info", new Object[0]));
                return;
            }
            EntityPlayerMP player = args.length < 3 ? RitualCreate.func_71521_c((ICommandSender)sender) : RitualCreate.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
            boolean safe = false;
            if (args.length > 1 && args.length < 4) {
                int k = args.length - 1;
                if (args[k].equals("true") || args[k].equals("false")) {
                    safe = Boolean.parseBoolean(args[k]);
                } else if (args[1].equals("safe")) {
                    safe = true;
                } else {
                    player = RitualCreate.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                }
            }
            BlockPos pos = player.func_180425_c().func_177977_b();
            World world = player.func_130014_f_();
            if (RitualHelper.createRitual(world, pos, direction = player.func_174811_aO(), BloodMagic.RITUAL_MANAGER.getRitual(args[0]), safe)) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.success", new Object[0]));
            } else if (!safe) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.ritual.create.error.outOfWorldBoundaries", new Object[0]));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bloodmagic.ritaul.create.error.unsafe", new Object[0]));
            }
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.bloodmagic.ritual.create.help";
        }
    }
}

