/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.altar.AltarUtil;
import WayofTime.bloodmagic.altar.ComponentType;
import WayofTime.bloodmagic.altar.IAltarManipulator;
import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.block.BlockDecorative;
import WayofTime.bloodmagic.block.IBMBlock;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.iface.IAltarReader;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.iface.IDocumentedBlock;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class BlockAltar
extends Block
implements IVariantProvider,
IDocumentedBlock,
IBMBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final AxisAlignedBB BODY = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    public BlockAltar() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("bloodmagic.altar");
        this.func_149647_a(BloodMagic.TAB_BM);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BODY;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return 0;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAltar) {
            TileAltar altar = (TileAltar)tile;
            ItemStack orbStack = altar.func_70301_a(0);
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockDecorative) {
                if (orbStack.func_77973_b() instanceof IBloodOrb && orbStack.func_77973_b() instanceof IBindable) {
                    BloodOrb orb = ((IBloodOrb)orbStack.func_77973_b()).getOrb(orbStack);
                    Binding binding = ((IBindable)orbStack.func_77973_b()).getBinding(orbStack);
                    if (orb != null && binding != null) {
                        SoulNetwork soulNetwork = NetworkHelper.getSoulNetwork(binding);
                        int maxEssence = orb.getCapacity();
                        int currentEssence = soulNetwork.getCurrentEssence();
                        int level = currentEssence * 15 / maxEssence;
                        return Math.min(15, level) % 16;
                    }
                }
            } else {
                int maxEssence = altar.getCapacity();
                int currentEssence = altar.getCurrentBlood();
                int level = currentEssence * 15 / maxEssence;
                return Math.min(15, level) % 16;
            }
        }
        return 0;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileAltar altar = (TileAltar)world.func_175625_s(pos);
        if (altar == null || player.func_70093_af()) {
            return false;
        }
        ItemStack playerItem = player.func_184586_b(hand);
        if (playerItem.func_77973_b() instanceof IAltarReader || playerItem.func_77973_b() instanceof IAltarManipulator) {
            playerItem.func_77973_b().func_77659_a(world, player, hand);
            return true;
        }
        if (Utils.insertItemToTile(altar, player)) {
            altar.startCycle();
        } else {
            altar.setActive();
        }
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState blockState) {
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof TileAltar) {
            ((TileAltar)tile).dropItems();
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAltar();
    }

    @Override
    public List<ITextComponent> getDocumentation(EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        ArrayList<ITextComponent> docs = new ArrayList<ITextComponent>();
        IBloodAltar altar = (IBloodAltar)world.func_175625_s(pos);
        Pair<BlockPos, ComponentType> missingBlock = AltarUtil.getFirstMissingComponent(world, pos, altar.getTier().toInt());
        if (missingBlock != null) {
            docs.add((ITextComponent)new TextComponentTranslation("chat.bloodmagic.altar.nextTier", new Object[]{new TextComponentTranslation(((ComponentType)((Object)missingBlock.getRight())).getKey(), new Object[0]), Utils.prettifyBlockPosString((BlockPos)missingBlock.getLeft())}));
        }
        return docs;
    }

    @Override
    public ItemBlock getItem() {
        return new ItemBlock((Block)this);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 0;
        }
        return 15;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }
}

