/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.impl.recipe;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public class RecipeTartaricForge {
    @Nonnull
    private final NonNullList<Ingredient> input;
    @Nonnull
    private final ItemStack output;
    @Nonnegative
    private final double minimumSouls;
    @Nonnegative
    private final double soulDrain;

    public RecipeTartaricForge(@Nonnull NonNullList<Ingredient> input, @Nonnull ItemStack output, @Nonnegative double minimumSouls, @Nonnegative double soulDrain) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((minimumSouls >= 0.0 ? 1 : 0) != 0, (Object)"minimumSouls cannot be negative.");
        Preconditions.checkArgument((soulDrain >= 0.0 ? 1 : 0) != 0, (Object)"soulDrain cannot be negative.");
        this.input = input;
        this.output = output;
        this.minimumSouls = minimumSouls;
        this.soulDrain = soulDrain;
    }

    @Nonnull
    public final NonNullList<Ingredient> getInput() {
        return this.input;
    }

    @Nonnull
    public final ItemStack getOutput() {
        return this.output;
    }

    @Nonnegative
    public final double getMinimumSouls() {
        return this.minimumSouls;
    }

    @Nonnegative
    public final double getSoulDrain() {
        return this.soulDrain;
    }
}

