/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.xalcon.torchmaster.client.ClientTorchRegistries;
import net.xalcon.torchmaster.client.ClientTorchRegistry;
import net.xalcon.torchmaster.client.renderer.TorchVolumeRenderHandler;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="torchmaster")
public class EventHandlerClient {
    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        ClientTorchRegistries.clearAll();
        TorchVolumeRenderHandler.clearList();
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        TorchVolumeRenderHandler.clearList();
    }

    @SubscribeEvent
    public static void onGlobalTickEvent(TickEvent.ClientTickEvent event) {
        WorldClient world;
        if (event.phase == TickEvent.Phase.END && (world = Minecraft.func_71410_x().field_71441_e) != null) {
            ClientTorchRegistry registry = ClientTorchRegistries.getRegistryForDimension(world.field_73011_w.getDimension());
            registry.onClientTick((World)world);
            TorchVolumeRenderHandler.onGlobalTick((World)world);
        }
    }

    @SubscribeEvent
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        if ("ambient.cave".equals(event.getName())) {
            ISound sound = event.getSound();
            if (sound == null) {
                return;
            }
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            ClientTorchRegistry registry = ClientTorchRegistries.getRegistryForDimension(world.field_73011_w.getDimension());
            if (registry.isPositionInRange(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i())) {
                event.setResultSound(null);
            }
        }
    }
}

