/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.varia;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class RarityRandomSelector<K, E> {
    private boolean dirty = true;
    private boolean createdDistribution = false;
    private final boolean rarityScalesBySize;
    private final Map<K, Float> keys = new HashMap<K, Float>();
    private float minChance = Float.MAX_VALUE;
    private float maxChance = Float.MIN_VALUE;
    private final Distribution defaultDistribution = new Distribution();
    private final Map<K, List<E>> items = new HashMap<K, List<E>>();

    public RarityRandomSelector(boolean rarityScalesBySize) {
        this.rarityScalesBySize = rarityScalesBySize;
    }

    public void addRarity(K key, float chance) {
        if (this.createdDistribution) {
            throw new IllegalStateException("Can't modify a RarityRandomSelector after calling createDistribution");
        }
        this.keys.put(key, Float.valueOf(chance));
        this.items.put(key, new ArrayList());
        if (chance < this.minChance) {
            this.minChance = chance;
        }
        if (chance > this.maxChance) {
            this.maxChance = chance;
        }
        this.dirty = true;
    }

    public void addItem(K key, E item) {
        if (this.createdDistribution) {
            throw new IllegalStateException("Can't modify a RarityRandomSelector after calling createDistribution");
        }
        this.items.get(key).add(item);
        this.dirty = true;
    }

    private void setupDistribution(Distribution distribution, float bonus) {
        float add = bonus * (this.maxChance - this.minChance);
        distribution.reset();
        this.keys.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).forEachOrdered(entry -> {
            Object key = entry.getKey();
            int length = this.items.get(key).size();
            if (length > 0) {
                float chance = ((Float)entry.getValue()).floatValue() + add;
                distribution.addKey(key, this.rarityScalesBySize ? chance * (float)length : chance);
            }
        });
    }

    public Distribution createDistribution(float bonus) {
        this.createdDistribution = true;
        Distribution distribution = new Distribution();
        this.setupDistribution(distribution, bonus);
        return distribution;
    }

    public E select(Random random) {
        if (this.dirty) {
            this.dirty = false;
            this.setupDistribution(this.defaultDistribution, 0.0f);
        }
        return this.defaultDistribution.select(random);
    }

    public class Distribution {
        private final NavigableMap<Float, K> keysChance = new TreeMap();
        private float totalChance = 0.0f;

        private void reset() {
            this.keysChance.clear();
            this.totalChance = 0.0f;
        }

        private void addKey(K key, float chance) {
            this.totalChance += chance;
            this.keysChance.put(Float.valueOf(this.totalChance), (Float)key);
        }

        public E select(Random random) {
            Object key = this.keysChance.ceilingEntry(Float.valueOf(random.nextFloat() * this.totalChance)).getValue();
            List list = (List)RarityRandomSelector.this.items.get(key);
            if (list == null) {
                return null;
            }
            return list.get(random.nextInt(list.size()));
        }
    }
}

