/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.List;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftoolsdim.blocks.GenericRFToolsBlock;
import mcjty.rftoolsdim.blocks.absorbers.TerrainAbsorberTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TerrainAbsorberBlock
extends GenericRFToolsBlock<TerrainAbsorberTileEntity, EmptyContainer> {
    public TerrainAbsorberBlock() {
        super(Material.field_151573_f, TerrainAbsorberTileEntity.class, EmptyContainer::new, "terrain_absorber", false);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TerrainAbsorberTileEntity tileEntity;
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TerrainAbsorberTileEntity && (tileEntity = (TerrainAbsorberTileEntity)te).getTerrainName() != null) {
            String terrainName = tileEntity.getTerrainName();
            int absorbing = tileEntity.getAbsorbing();
            int pct = (DimletConstructionConfiguration.maxTerrainAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxTerrainAbsorbtion;
            probeInfo.text(TextFormatting.GREEN + "Terrain: " + terrainName).progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TerrainAbsorberTileEntity tileEntity = (TerrainAbsorberTileEntity)accessor.getTileEntity();
        if (tileEntity != null && tileEntity.getTerrainName() != null) {
            String terrainName = tileEntity.getTerrainName();
            int absorbing = tileEntity.getAbsorbing();
            int pct = (DimletConstructionConfiguration.maxTerrainAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxTerrainAbsorbtion;
            currenttip.add(TextFormatting.GREEN + "Terrain: " + terrainName + " (" + pct + "%)");
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("terrain")) {
            String terrainName = tagCompound.func_74779_i("terrain");
            list.add(TextFormatting.GREEN + "Terrain: " + terrainName);
            int absorbing = tagCompound.func_74762_e("absorbing");
            int pct = (DimletConstructionConfiguration.maxTerrainAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxTerrainAbsorbtion;
            list.add(TextFormatting.GREEN + "Absorbed: " + pct + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Place this block in an area and it will");
            list.add(TextFormatting.WHITE + "gradually absorb the essence of the terrain it is in.");
            list.add(TextFormatting.WHITE + "You can use the end result in the Dimlet Workbench.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        this.restoreBlockFromNBT(world, pos, itemStack);
        if (!world.field_72995_K) {
            TerrainAbsorberTileEntity tileEntity = (TerrainAbsorberTileEntity)world.func_175625_s(pos);
            tileEntity.placeDown();
        }
        this.setOwner(world, pos, entityLivingBase);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getGuiID() {
        return -1;
    }
}

