/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.recipe.extreme;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import morph.avaritia.recipe.extreme.ExtremeRecipeBase;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;

public class ExtremeShapelessRecipe
extends ExtremeRecipeBase {
    protected ItemStack output;
    protected NonNullList<Ingredient> input;

    public ExtremeShapelessRecipe(NonNullList<Ingredient> input, ItemStack result) {
        this.input = input;
        this.output = result.func_77946_l();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.input;
    }

    @Override
    public boolean canFit(int p_194133_1_, int p_194133_2_) {
        return p_194133_1_ * p_194133_2_ >= this.input.size();
    }

    @Override
    public boolean matches(@Nonnull InventoryCrafting var1, @Nonnull World world) {
        NonNullList required = NonNullList.func_191196_a();
        required.addAll(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                Ingredient ing = (Ingredient)req.next();
                if (!ing.apply(slot)) continue;
                for (ItemStack stack : ing.func_193365_a()) {
                    if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slot)) continue;
                    inRecipe = true;
                    req.remove();
                    break;
                }
                if (!inRecipe) continue;
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public static ExtremeShapelessRecipe fromJson(JsonContext context, JsonObject json) {
        NonNullList ings = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            Ingredient i = CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context);
            if (i == Ingredient.field_193370_a) continue;
            ings.add((Object)i);
        }
        if (ings.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        return new ExtremeShapelessRecipe((NonNullList<Ingredient>)ings, itemstack);
    }
}

