/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.mc;

import aroma1997.backup.common.plugin.BackupPlugin;
import aroma1997.backup.common.plugin.PluginLoader;
import aroma1997.backup.common.util.Util;
import aroma1997.backup.mc.CommandBackup;
import aroma1997.backup.mc.CommandWrapper;
import aroma1997.backup.mc.Config;
import aroma1997.backup.mc.EventListener;
import aroma1997.backup.mc.MinecraftEnv;
import aroma1997.backup.mc.ThreadBackup;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.ServerUtil;
import aroma1997.core.util.registry.TickRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="aromabackup", name="AromaBackup", dependencies="required-after:aroma1997core", certificateFingerprint="dfbfe4c473253d8c5652417689848f650b2cbe32", acceptedMinecraftVersions="[1.12]")
public class AromaBackup
implements ICommandSender {
    public Logger logger = LogHelper.genNewLogger((String)"AromaBackup");
    private Timer timer;
    private ModMetadata metadata;
    @Mod.Instance(value="aromabackup")
    public static AromaBackup instance;
    private static final Collection<String> overridenCommands;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        new MinecraftEnv();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.metadata = event.getModMetadata();
        Util.registerInternalCompressions();
        PluginLoader.load();
        this.logger.info("Loading " + PluginLoader.getPlugins().size() + " modules.");
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            this.logger.info("Loading module: \"" + plugin.getName() + "\".");
            plugin.load();
        }
        this.logger.info("Done loading plugins.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.logger.info("Postloading " + PluginLoader.getPlugins().size() + " modules.");
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            this.logger.info("Loading module: \"" + plugin.getName() + "\".");
            plugin.postLoad();
        }
        this.logger.info("Done postloading plugins.");
        MinecraftForge.EVENT_BUS.register(EventListener.class);
        Config.instance.reload();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.metadata.description = this.metadata.description + "\n " + PluginLoader.getPlugins().size() + " loaded Plugins:\n";
        boolean hasPlugins = false;
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            if (hasPlugins) {
                this.metadata.description = ", ";
            }
            this.metadata.description = this.metadata.description + plugin.getName();
            hasPlugins = true;
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBackup());
        ICommandManager commandManager = event.getServer().func_71187_D();
        ArrayList<CommandWrapper> added = new ArrayList<CommandWrapper>(overridenCommands.size());
        for (String string : overridenCommands) {
            ICommand command = (ICommand)commandManager.func_71555_a().get(string);
            if (command == null) continue;
            added.add(new CommandWrapper(command));
        }
        for (ICommand iCommand : added) {
            event.registerServerCommand(iCommand);
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        this.setupTimerDelay(Config.instance.delay);
        if (Config.instance.onStartup) {
            ThreadBackup.startBackup(ThreadBackup.BackupType.DEFAULT);
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.timer.cancel();
        this.logger.info("Delaying server stop to finish Backup.");
        while (ThreadBackup.isBackupRunning()) {
            try {
                TickRegistry.SERVER.tick();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LogHelper.log((Level)Level.WARN, (String)"Invalid fingerprint detected! The version of the mod is most likely modified and an inofficial release.");
        LogHelper.log((Level)Level.WARN, (String)"Use with caution.");
    }

    public String func_70005_c_() {
        return "AromaBackup";
    }

    public boolean func_70003_b(int i, String s) {
        return true;
    }

    public World func_130014_f_() {
        return null;
    }

    public void func_145747_a(ITextComponent comp) {
        this.logger.log(Level.TRACE, comp.func_150260_c());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return ServerUtil.getChatForString((String)LogHelper.getLoggerPrefix((boolean)true, (Logger)this.logger, (String)this.func_70005_c_()));
    }

    public boolean func_174792_t_() {
        return true;
    }

    public MinecraftServer func_184102_h() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static String getSideString() {
        return FMLCommonHandler.instance().getSide().toString().toLowerCase();
    }

    void setupTimer(long time) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        long delay = Config.instance.delay;
        if (delay > 0L) {
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ThreadBackup.startBackupOnSchedule();
                }
            }, new Date(time), delay);
        } else {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ThreadBackup.startBackupOnSchedule();
                }
            }, new Date(time));
        }
    }

    void setupTimerDelay(long delay) {
        this.setupTimer(System.currentTimeMillis() + delay);
    }

    static {
        overridenCommands = Arrays.asList("save-all", "save-on", "save-off");
    }
}

