/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nullable;
import mcjty.lib.varia.McJtyLibTeleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TeleportationTools {
    public static void performTeleport(EntityPlayer player, int dimension, BlockPos dest, @Nullable EnumFacing direction) {
        TeleportationTools.performTeleport(player, dimension, (double)dest.func_177958_n() + 0.5, (double)dest.func_177956_o() + 1.5, (double)dest.func_177952_p() + 0.5, direction);
    }

    public static void performTeleport(EntityPlayer player, int dimension, double destX, double destY, double destZ, @Nullable EnumFacing direction) {
        int oldId = player.func_130014_f_().field_73011_w.getDimension();
        float rotationYaw = player.field_70177_z;
        float rotationPitch = player.field_70125_A;
        if (oldId != dimension) {
            TeleportationTools.teleportToDimension(player, dimension, destX, destY, destZ);
        }
        if (direction != null) {
            TeleportationTools.fixOrientation((Entity)player, destX, destY, destZ, direction);
        } else {
            player.field_70177_z = rotationYaw;
            player.field_70125_A = rotationPitch;
        }
        player.func_70634_a(destX, destY, destZ);
    }

    public static World getWorldForDimension(int id) {
        WorldServer w = DimensionManager.getWorld((int)id);
        if (w == null) {
            w = DimensionManager.getWorld((int)0).func_73046_m().func_71218_a(id);
        }
        return w;
    }

    public static void teleportToDimension(EntityPlayer player, int dimension, double x, double y, double z) {
        int oldDimension = player.func_130014_f_().field_73011_w.getDimension();
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
        MinecraftServer server = player.func_130014_f_().func_73046_m();
        WorldServer worldServer = server.func_71218_a(dimension);
        if (worldServer == null) {
            return;
        }
        player.func_82242_a(0);
        worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(entityPlayerMP, dimension, (Teleporter)new McJtyLibTeleporter(worldServer, x, y, z));
        player.func_70634_a(x, y, z);
    }

    private static void facePosition(Entity entity, double newX, double newY, double newZ, BlockPos dest) {
        double d0 = (double)dest.func_177958_n() - newX;
        double d1 = (double)dest.func_177956_o() - (newY + (double)entity.func_70047_e());
        double d2 = (double)dest.func_177952_p() - newZ;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        entity.field_70125_A = TeleportationTools.updateRotation(entity.field_70125_A, f1);
        entity.field_70177_z = TeleportationTools.updateRotation(entity.field_70177_z, f);
    }

    private static float updateRotation(float angle, float targetAngle) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        return angle + f;
    }

    public static Entity teleportEntity(Entity entity, World destWorld, double newX, double newY, double newZ, EnumFacing facing) {
        World world = entity.func_130014_f_();
        if (entity instanceof EntityPlayer) {
            TeleportationTools.performTeleport((EntityPlayer)entity, destWorld.field_73011_w.getDimension(), newX, newY, newZ, facing);
            return entity;
        }
        float rotationYaw = entity.field_70177_z;
        float rotationPitch = entity.field_70125_A;
        if (world.field_73011_w.getDimension() != destWorld.field_73011_w.getDimension()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            entity.func_189511_e(tagCompound);
            tagCompound.func_82580_o("Dimension");
            Class<?> entityClass = entity.getClass();
            world.func_72900_e(entity);
            entity.field_70128_L = false;
            world.func_72866_a(entity, false);
            Entity newEntity = EntityList.func_191304_a(entityClass, (World)destWorld);
            newEntity.func_70020_e(tagCompound);
            if (facing != null) {
                TeleportationTools.fixOrientation(newEntity, newX, newY, newZ, facing);
            } else {
                newEntity.field_70177_z = rotationYaw;
                newEntity.field_70125_A = rotationPitch;
            }
            newEntity.func_70012_b(newX, newY, newZ, newEntity.field_70177_z, newEntity.field_70125_A);
            boolean flag = newEntity.field_98038_p;
            newEntity.field_98038_p = true;
            destWorld.func_72838_d(newEntity);
            newEntity.field_98038_p = flag;
            destWorld.func_72866_a(newEntity, false);
            entity.field_70128_L = true;
            ((WorldServer)world).func_82742_i();
            ((WorldServer)destWorld).func_82742_i();
            return newEntity;
        }
        if (facing != null) {
            TeleportationTools.fixOrientation(entity, newX, newY, newZ, facing);
        } else {
            entity.field_70177_z = rotationYaw;
            entity.field_70125_A = rotationPitch;
        }
        entity.func_70012_b(newX, newY, newZ, entity.field_70177_z, entity.field_70125_A);
        destWorld.func_72866_a(entity, false);
        return entity;
    }

    private static void fixOrientation(Entity entity, double newX, double newY, double newZ, EnumFacing facing) {
        if (facing != EnumFacing.DOWN && facing != EnumFacing.UP) {
            TeleportationTools.facePosition(entity, newX, newY, newZ, new BlockPos(newX, newY, newZ).func_177967_a(facing, 4));
        }
    }
}

