/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.multipart.IPartBlock;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.setup.ModSetup;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultipartItemBlock
extends ItemBlock {
    public MultipartItemBlock(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        int meta = this.func_77647_b(itemstack.func_77960_j());
        IBlockState toPlace = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player, hand);
        PartSlot slot = PartSlot.NONE;
        if (this.field_150939_a instanceof IPartBlock) {
            slot = ((IPartBlock)this.field_150939_a).getSlotFromState(world, pos, toPlace);
        }
        if (!block.func_176200_f((IBlockAccess)world, pos) && !this.canFitInside(block, world, pos, slot)) {
            pos = pos.func_177972_a(facing);
            iblockstate = world.func_180495_p(pos);
            block = iblockstate.func_177230_c();
        }
        if (player.func_175151_a(pos, facing, itemstack)) {
            toPlace = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player, hand);
            if (this.field_150939_a instanceof IPartBlock) {
                slot = ((IPartBlock)this.field_150939_a).getSlotFromState(world, pos, toPlace);
            }
            if (this.canFitInside(block, world, pos, slot)) {
                if (this.placeBlockAtInternal(itemstack, player, world, pos, facing, hitX, hitY, hitZ, toPlace, slot)) {
                    SoundType soundtype = toPlace.func_177230_c().getSoundType(toPlace, world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    itemstack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            if (world.func_190527_a(this.field_150939_a, pos, false, facing, null)) {
                if (this.placeBlockAtInternal(itemstack, player, world, pos, facing, hitX, hitY, hitZ, toPlace, slot)) {
                    SoundType soundtype = toPlace.func_177230_c().getSoundType(toPlace, world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    itemstack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    private boolean canFitInside(Block block, World world, BlockPos pos, PartSlot slot) {
        if (block != ModSetup.multipartBlock) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            MultipartTE.Part part = ((MultipartTE)te).getParts().get((Object)slot);
            return part == null;
        }
        return false;
    }

    private TileEntity createTileEntity(World world, IBlockState state) {
        return state.func_177230_c().createTileEntity(world, state);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        return false;
    }

    private boolean placeBlockAtInternal(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState, @Nonnull PartSlot slot) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartTE) {
            TileEntity tileEntity = this.createTileEntity(world, newState);
            if (tileEntity instanceof GenericTileEntity && stack.func_77978_p() != null) {
                ((GenericTileEntity)tileEntity).readRestorableFromNBT(stack.func_77978_p());
            }
            ((MultipartTE)te).addPart(slot, newState, tileEntity);
            return true;
        }
        IBlockState multiState = ModSetup.multipartBlock.func_176223_P();
        if (!world.func_180501_a(pos, multiState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == ModSetup.multipartBlock) {
            MultipartItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            te = world.func_175625_s(pos);
            if (te instanceof MultipartTE) {
                TileEntity tileEntity = this.createTileEntity(world, newState);
                if (tileEntity instanceof GenericTileEntity && stack.func_77942_o()) {
                    ((GenericTileEntity)tileEntity).readRestorableFromNBT(stack.func_77978_p());
                }
                ((MultipartTE)te).addPart(slot, newState, tileEntity);
                return true;
            }
            newState.func_177230_c().func_180633_a(world, pos, newState, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    private RayTraceResult getMovingObjectPositionFromPlayer(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float pitch = playerIn.field_70125_A;
        float yaw = playerIn.field_70177_z;
        double x = playerIn.field_70165_t;
        double y = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double z = playerIn.field_70161_v;
        Vec3d vec3 = new Vec3d(x, y, z);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reach = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            reach = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.func_72441_c((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return worldIn.func_147447_a(vec3, vec31, useLiquids, !useLiquids, false);
    }

    private void addCable(World world, BlockPos pos, EnumFacing directionHit, float hitX, float hitY, float hitZ) {
        Vec3d vector;
        BlockPos adjacentC = pos.func_177972_a(directionHit.func_176734_d());
        if (world.isSideSolid(adjacentC, directionHit)) {
            vector = new Vec3d((double)((float)adjacentC.func_177958_n() + hitX + (float)directionHit.func_176730_m().func_177958_n() / 10.0f), (double)((float)adjacentC.func_177956_o() + hitY + (float)directionHit.func_176730_m().func_177956_o() / 10.0f), (double)((float)adjacentC.func_177952_p() + hitZ + (float)directionHit.func_176730_m().func_177952_p() / 10.0f));
        } else {
            Set excluded = Collections.emptySet();
            vector = new Vec3d((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
        }
        Vec3d finalVector = vector;
    }
}

