/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.api.smartwrench;

import java.util.HashMap;
import java.util.Map;

public enum SmartWrenchMode {
    MODE_WRENCH("w", "wrench"),
    MODE_SELECT("s", "focus");

    private static Map<String, SmartWrenchMode> codeToMode;
    private final String code;
    private final String name;

    private SmartWrenchMode(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static SmartWrenchMode getMode(String code) {
        return codeToMode.get(code);
    }

    static {
        codeToMode = new HashMap<String, SmartWrenchMode>();
        for (SmartWrenchMode mode : SmartWrenchMode.values()) {
            codeToMode.put(mode.getCode(), mode);
        }
    }
}

