/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDreadBeast;
import com.github.alexthe666.iceandfire.entity.EntityDreadGhoul;
import com.github.alexthe666.iceandfire.entity.EntityDreadLichSkull;
import com.github.alexthe666.iceandfire.entity.EntityDreadMob;
import com.github.alexthe666.iceandfire.entity.EntityDreadScuttler;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IDreadMob;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.ai.DreadAITargetNonDread;
import com.github.alexthe666.iceandfire.entity.ai.DreadLichAIStrife;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityDreadLich
extends EntityDreadMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IRangedAttackMob {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dread_lich"));
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDreadLich.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MINION_COUNT = EntityDataManager.func_187226_a(EntityDreadLich.class, (DataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_SPAWN = Animation.create((int)40);
    public static Animation ANIMATION_SUMMON = Animation.create((int)15);
    private final DreadLichAIStrife aiArrowAttack = new DreadLichAIStrife(this, 1.0, 20, 15.0f);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
    private int animationTick;
    private Animation currentAnimation;
    private int fireCooldown = 0;
    private int minionCooldown = 0;

    public EntityDreadLich(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{IDreadMob.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DreadAITargetNonDread((EntityCreature)this, EntityLivingBase.class, false, (Predicate<? super EntityLivingBase>)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && DragonUtils.canHostilesTarget(entity);
            }
        }));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(MINION_COUNT, (Object)0);
    }

    @Override
    public void func_70636_d() {
        Block belowBlock;
        super.func_70636_d();
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30 && (belowBlock = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c()) != Blocks.field_150350_a) {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.func_174813_aQ().field_72338_b, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{Block.func_149682_b((Block)belowBlock)});
            }
        }
        if (this.field_70170_p.field_72995_K && this.getAnimation() == ANIMATION_SUMMON) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            IceAndFire.PROXY.spawnParticle("dread_torch", this.field_70165_t + (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v + (double)f2 * 0.6, d0, d1, d2);
            IceAndFire.PROXY.spawnParticle("dread_torch", this.field_70165_t - (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v - (double)f2 * 0.6, d0, d1, d2);
        }
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
        if (this.minionCooldown > 0) {
            --this.minionCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(IafItemRegistry.lich_staff));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.setAnimation(ANIMATION_SPAWN);
        this.func_180481_a(difficulty);
        this.setVariant(this.field_70146_Z.nextInt(5));
        this.setCombatTask();
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("MinionCount", this.getMinionCount());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setMinionCount(compound.func_74762_e("MinionCount"));
        this.setCombatTask();
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getMinionCount() {
        return (Integer)this.field_70180_af.func_187225_a(MINION_COUNT);
    }

    public void setMinionCount(int minions) {
        this.field_70180_af.func_187227_b(MINION_COUNT, (Object)minions);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN, ANIMATION_SUMMON};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean shouldFear() {
        return true;
    }

    @Override
    public Entity getCommander() {
        return null;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() == IafItemRegistry.lich_staff) {
                int i = 100;
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        boolean flag = false;
        if (this.getMinionCount() < 5 && this.minionCooldown == 0) {
            this.setAnimation(ANIMATION_SUMMON);
            this.func_184185_a(IafSoundRegistry.DREAD_LICH_SUMMON, this.func_70599_aP(), this.func_70647_i());
            EntityLiving minion = this.getRandomNewMinion();
            int x = (int)this.field_70165_t - 5 + this.field_70146_Z.nextInt(10);
            int z = (int)this.field_70161_v - 5 + this.field_70146_Z.nextInt(10);
            double y = this.getHeightFromXZ(x, z);
            minion.func_70012_b((double)x + 0.5, y, (double)z + 0.5, this.field_70177_z, this.field_70125_A);
            minion.func_70624_b(target);
            minion.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            if (minion instanceof EntityDreadMob) {
                ((EntityDreadMob)minion).setCommanderId(this.func_110124_au());
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)minion);
            }
            this.minionCooldown = 100;
            this.setMinionCount(this.getMinionCount() + 1);
            flag = true;
        }
        if (this.fireCooldown == 0 && !flag) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            this.func_184185_a(SoundEvents.field_187945_hs, this.func_70599_aP(), this.func_70647_i());
            EntityDreadLichSkull skull = new EntityDreadLichSkull(this.field_70170_p, (EntityLivingBase)this, 6.0);
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O * 2.0f) - skull.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            skull.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 0.0f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
            this.field_70170_p.func_72838_d((Entity)skull);
            this.fireCooldown = 100;
        }
    }

    private EntityLiving getRandomNewMinion() {
        float chance = this.field_70146_Z.nextFloat();
        if (chance > 0.5f) {
            return new EntityDreadThrall(this.field_70170_p);
        }
        if (chance > 0.35f) {
            return new EntityDreadGhoul(this.field_70170_p);
        }
        if (chance > 0.15f) {
            return new EntityDreadBeast(this.field_70170_p);
        }
        return new EntityDreadScuttler(this.field_70170_p);
    }

    private double getHeightFromXZ(int x, int z) {
        BlockPos thisPos = new BlockPos((double)x, this.field_70163_u + 7.0, (double)z);
        while (this.field_70170_p.func_175623_d(thisPos) && thisPos.func_177956_o() > 2) {
            thisPos = thisPos.func_177977_b();
        }
        double height = (double)thisPos.func_177956_o() + 1.0;
        AxisAlignedBB bb = this.field_70170_p.func_180495_p(thisPos).func_185890_d((IBlockAccess)this.field_70170_p, thisPos);
        if (bb != null) {
            height = (double)thisPos.func_177956_o() + bb.field_72337_e;
        }
        return height;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.func_184191_r(entityIn);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190032_gu;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190034_gw;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190033_gv;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_190035_gx, 0.15f, 1.0f);
    }
}

