/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.tile;

import com.github.alexthe666.iceandfire.entity.tile.TileEntityDreadPortal;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;

public class RenderDreadPortal
extends TileEntitySpecialRenderer<TileEntityDreadPortal> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("iceandfire:textures/environment/dread_portal_background.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("iceandfire:textures/environment/dread_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    public void render(TileEntityDreadPortal te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179140_f();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        RANDOM.setSeed(31100L);
        GlStateManager.func_179094_E();
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.func_179111_a((int)2983, (FloatBuffer)PROJECTION);
        double d0 = x * x + y * y + z * z;
        int i = te == null ? 14 : this.getPasses(d0);
        float f = this.getOffset();
        boolean flag = false;
        for (int j = 0; j < i; ++j) {
            GlStateManager.func_179094_E();
            float f1 = 2.0f / (float)(18 - j);
            if (j == 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(END_SKY_TEXTURE);
                f1 = 0.85f;
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (j >= 1) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(END_PORTAL_TEXTURE);
                flag = true;
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
            }
            if (j == 1) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            float f2 = j + 1;
            float time = ((float)(Minecraft.func_71410_x().field_71439_g.field_70173_aa - 1) + 1.0f * partialTicks) % 800.0f / 800.0f;
            if (te == null) {
                time = ((float)(Minecraft.func_71410_x().field_181542_y.func_181750_b() - 1) + 1.0f * partialTicks) % 3200.0f / 3200.0f;
            }
            GlStateManager.func_179137_b((double)((double)((j == 0 ? 7.0f : 17.0f) / f2 * time) * RANDOM.nextGaussian()), (double)(j == 0 ? 0.0 : (double)((2.0f + f2 / 1.5f) * -time)), (double)0.0);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float scal = j == 0 ? 4.0f : (te == null ? 2.0f : 0.5f);
            GlStateManager.func_179152_a((float)scal, (float)(j == 0 ? 1.0f : scal), (float)1.0f);
            GlStateManager.func_179110_a((FloatBuffer)PROJECTION);
            GlStateManager.func_179110_a((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float f3 = (RANDOM.nextFloat() * 0.05f + 0.9f) * f1;
            float f4 = (RANDOM.nextFloat() * 0.05f + 0.9f) * f1;
            float f5 = 0.98f;
            float alpha2 = 1.0f;
            if (te == null || te.shouldRenderFace(EnumFacing.SOUTH)) {
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (te == null || te.shouldRenderFace(EnumFacing.NORTH)) {
                bufferbuilder.func_181662_b(x, y + 1.0, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (te == null || te.shouldRenderFace(EnumFacing.EAST)) {
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (te == null || te.shouldRenderFace(EnumFacing.WEST)) {
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (te == null || te.shouldRenderFace(EnumFacing.DOWN)) {
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (te == null || te.shouldRenderFace(EnumFacing.UP)) {
                bufferbuilder.func_181662_b(x, y + (double)f, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + (double)f, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + (double)f, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y + (double)f, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(END_SKY_TEXTURE);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.R);
        int lightI = Minecraft.func_71410_x().field_71441_e.func_175626_b(new BlockPos(x, y, z), Minecraft.func_71410_x().field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, new BlockPos(x, y, z)));
        int j = lightI % 65536;
        int k = lightI / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        if (flag) {
            Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        }
    }

    protected int getPasses(double p_191286_1_) {
        int i = p_191286_1_ > 36864.0 ? 1 : (p_191286_1_ > 25600.0 ? 3 : (p_191286_1_ > 16384.0 ? 5 : (p_191286_1_ > 9216.0 ? 7 : (p_191286_1_ > 4096.0 ? 9 : (p_191286_1_ > 1024.0 ? 11 : (p_191286_1_ > 576.0 ? 13 : (p_191286_1_ > 256.0 ? 14 : 15)))))));
        return i;
    }

    protected float getOffset() {
        return 1.0f;
    }

    private FloatBuffer getBuffer(float p_147525_1_, float p_147525_2_, float p_147525_3_, float p_147525_4_) {
        this.buffer.clear();
        this.buffer.put(p_147525_1_).put(p_147525_2_).put(p_147525_3_).put(p_147525_4_);
        this.buffer.flip();
        return this.buffer;
    }
}

