/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.effect.time;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopZone;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TimeStopEffectHelper {
    private static Random rand = new Random();
    @Nonnull
    private BlockPos position;
    private float range;
    private TimeStopZone.EntityTargetController targetController;
    private boolean reducedParticles;

    private TimeStopEffectHelper(@Nonnull BlockPos position, float range, TimeStopZone.EntityTargetController targetController, boolean reducedParticles) {
        this.position = position;
        this.range = range;
        this.targetController = targetController;
        this.reducedParticles = reducedParticles;
    }

    static TimeStopEffectHelper fromZone(TimeStopZone zone) {
        return new TimeStopEffectHelper(zone.offset, zone.range, zone.targetController, zone.reducedParticles);
    }

    @Nonnull
    public BlockPos getPosition() {
        return this.position;
    }

    public float getRange() {
        return this.range;
    }

    public TimeStopZone.EntityTargetController getTargetController() {
        return this.targetController;
    }

    @SideOnly(value=Side.CLIENT)
    static void playEntityParticles(EntityLivingBase e) {
        double x = e.field_70165_t - (double)e.field_70130_N + (double)(rand.nextFloat() * e.field_70130_N * 2.0f);
        double y = e.field_70163_u + (double)(rand.nextFloat() * e.field_70131_O);
        double z = e.field_70161_v - (double)e.field_70130_N + (double)(rand.nextFloat() * e.field_70130_N * 2.0f);
        TimeStopEffectHelper.playEntityParticles(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playEntityParticles(PktParticleEvent ev) {
        TimeStopEffectHelper.playEntityParticles(ev.getVec().getX(), ev.getVec().getY(), ev.getVec().getZ());
    }

    @SideOnly(value=Side.CLIENT)
    static void playEntityParticles(double x, double y, double z) {
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(x, y, z);
        p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        p.scale(rand.nextFloat() * 0.5f + 0.3f).gravity(0.004);
        p.setMaxAge(40 + rand.nextInt(20));
        if (rand.nextFloat() < 0.9f) {
            p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(rand.nextFloat() * 0.2f + 0.1f).gravity(0.004);
            p.setMaxAge(30 + rand.nextInt(10));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playClientTickEffect() {
        Random rand = new Random();
        List entities = Minecraft.func_71410_x().field_71441_e.func_175647_a(EntityLivingBase.class, new AxisAlignedBB((double)(-this.range), (double)(-this.range), (double)(-this.range), (double)this.range, (double)this.range, (double)this.range).func_72317_d((double)this.position.func_177958_n(), (double)this.position.func_177956_o(), (double)this.position.func_177952_p()), EntitySelectors.func_188443_a((double)this.position.func_177958_n(), (double)this.position.func_177956_o(), (double)this.position.func_177952_p(), (double)this.range));
        for (EntityLivingBase e : entities) {
            if (e == null || e.field_70128_L || !this.targetController.shouldFreezeEntity(e) || this.reducedParticles && rand.nextInt(5) == 0) continue;
            TimeStopEffectHelper.playEntityParticles(e);
        }
        int minX = MathHelper.func_76128_c((double)((double)((float)this.position.func_177958_n() - this.range) / 16.0));
        int maxX = MathHelper.func_76128_c((double)((double)((float)this.position.func_177958_n() + this.range) / 16.0));
        int minZ = MathHelper.func_76128_c((double)((double)((float)this.position.func_177952_p() - this.range) / 16.0));
        int maxZ = MathHelper.func_76128_c((double)((double)((float)this.position.func_177952_p() + this.range) / 16.0));
        for (int xx = minX; xx <= maxX; ++xx) {
            for (int zz = minZ; zz <= maxZ; ++zz) {
                Chunk ch = Minecraft.func_71410_x().field_71441_e.func_72964_e(xx, zz);
                if (ch.func_76621_g()) continue;
                Map map = ch.func_177434_r();
                for (Map.Entry teEntry : map.entrySet()) {
                    TileEntity te;
                    if (this.reducedParticles && rand.nextInt(5) == 0 || (te = (TileEntity)teEntry.getValue()) == null || !(te instanceof ITickable) || !(this.position.func_185332_f(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()) <= (double)this.range)) continue;
                    double x = (float)te.func_174877_v().func_177958_n() + rand.nextFloat();
                    double y = (float)te.func_174877_v().func_177956_o() + rand.nextFloat();
                    double z = (float)te.func_174877_v().func_177952_p() + rand.nextFloat();
                    EntityFXFacingParticle p = EffectHelper.genericFlareParticle(x, y, z);
                    p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                    p.scale(rand.nextFloat() * 0.5f + 0.3f).gravity(0.004);
                    p.setMaxAge(40 + rand.nextInt(20));
                    if (!(rand.nextFloat() < 0.9f)) continue;
                    p = EffectHelper.genericFlareParticle(x, y, z);
                    p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                    p.scale(rand.nextFloat() * 0.2f + 0.1f).gravity(0.004);
                    p.setMaxAge(30 + rand.nextInt(10));
                }
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (this.reducedParticles && rand.nextInt(5) == 0) continue;
            Vector3 pos = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vec3i)this.position);
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(rand.nextFloat() * 0.5f + 0.3f).gravity(0.004);
            p.setMaxAge(40 + rand.nextInt(20));
            if (!(rand.nextFloat() < 0.9f)) continue;
            p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(rand.nextFloat() * 0.2f + 0.1f).gravity(0.004);
            p.setMaxAge(30 + rand.nextInt(10));
        }
        if (!(rand.nextInt(4) != 0 || this.reducedParticles && rand.nextInt(5) != 0)) {
            Vector3 rand1 = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vec3i)this.position);
            Vector3 rand2 = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vec3i)this.position);
            AstralSorcery.proxy.fireLightning((World)Minecraft.func_71410_x().field_71441_e, rand1, rand2, Color.WHITE);
        }
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound out = new NBTTagCompound();
        NBTHelper.writeBlockPosToNBT(this.position, out);
        out.func_74776_a("range", this.range);
        out.func_74782_a("targetController", (NBTBase)this.targetController.serializeNBT());
        out.func_74757_a("reducedParticles", this.reducedParticles);
        return out;
    }

    @Nonnull
    public static TimeStopEffectHelper deserializeNBT(NBTTagCompound cmp) {
        BlockPos at = NBTHelper.readBlockPosFromNBT(cmp);
        float range = cmp.func_74760_g("range");
        boolean reducedParticles = cmp.func_74767_n("reducedParticles");
        return new TimeStopEffectHelper(at, range, TimeStopZone.EntityTargetController.deserializeNBT(cmp.func_74775_l("targetController")), reducedParticles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeStopEffectHelper that = (TimeStopEffectHelper)o;
        return Float.compare(that.range, this.range) == 0 && this.position.equals((Object)that.position);
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + (this.range != 0.0f ? Float.floatToIntBits(this.range) : 0);
        return result;
    }
}

