/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingSprite;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.block.BlockGemCrystals;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.tile.base.TileSkybound;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileGemCrystals
extends TileSkybound {
    private static final Random rand = new Random();

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Nullable
    public BlockGemCrystals.GrowthStageType getGrowth() {
        IBlockState state = this.getBlockState();
        if (!(state.func_177230_c() instanceof BlockGemCrystals)) {
            return null;
        }
        return (BlockGemCrystals.GrowthStageType)((Object)state.func_177229_b(BlockGemCrystals.STAGE));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.tryGrow();
        } else {
            BlockGemCrystals.GrowthStageType growthStage = this.getGrowth();
            if (growthStage != null && growthStage.getGrowthStage() == 2) {
                this.playHarvestEffects(growthStage);
            }
        }
    }

    private void tryGrow() {
        double dstr;
        int r = 50000;
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(this.field_145850_b);
        if (this.doesSeeSky() && handle != null && (dstr = (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b)) > 0.0) {
            r = (int)((double)r * (0.7 + (1.0 - dstr) * 0.3));
        }
        if (this.field_145850_b.field_73012_v.nextInt(Math.max(r, 1)) == 0) {
            this.grow();
        }
    }

    public void grow() {
        IBlockState current = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(current.func_177230_c() instanceof BlockGemCrystals)) {
            return;
        }
        BlockGemCrystals.GrowthStageType stageType = (BlockGemCrystals.GrowthStageType)((Object)current.func_177229_b(BlockGemCrystals.STAGE));
        BlockGemCrystals.GrowthStageType next = null;
        switch (stageType) {
            case STAGE_0: {
                next = BlockGemCrystals.GrowthStageType.STAGE_1;
                break;
            }
            case STAGE_1: {
                if ((double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b) <= 0.1) {
                    next = BlockGemCrystals.GrowthStageType.STAGE_2_DAY;
                    break;
                }
                if ((double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b) >= 0.8) {
                    next = BlockGemCrystals.GrowthStageType.STAGE_2_NIGHT;
                    break;
                }
                next = BlockGemCrystals.GrowthStageType.STAGE_2_SKY;
                break;
            }
            case STAGE_2_SKY: {
                next = BlockGemCrystals.GrowthStageType.STAGE_1;
                break;
            }
            case STAGE_2_DAY: {
                next = BlockGemCrystals.GrowthStageType.STAGE_1;
                break;
            }
            case STAGE_2_NIGHT: {
                next = BlockGemCrystals.GrowthStageType.STAGE_1;
            }
        }
        if (next != null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, BlocksAS.gemCrystals.func_176223_P().func_177226_a(BlockGemCrystals.STAGE, (Comparable)((Object)next)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playHarvestEffects(BlockGemCrystals.GrowthStageType growthStage) {
        if (rand.nextInt(4) == 0) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((float)this.field_174879_c.func_177958_n() + rand.nextFloat(), (float)this.field_174879_c.func_177956_o() + rand.nextFloat(), (float)this.field_174879_c.func_177952_p() + rand.nextFloat());
            p.gravity(0.004);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.setColor(growthStage.getDisplayColor());
            p.scale(0.35f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playBreakParticles(PktParticleEvent event) {
        SpriteSheetResource sprite;
        Vector3 at = event.getVec();
        BlockGemCrystals.GrowthStageType growthStage = BlockGemCrystals.GrowthStageType.values()[(int)event.getAdditionalDataLong()];
        float scale = 0.4f;
        switch (growthStage) {
            case STAGE_0: {
                sprite = SpriteLibrary.spriteGemExplodeGray;
                scale = 0.5f;
                break;
            }
            case STAGE_1: {
                sprite = SpriteLibrary.spriteGemExplodeGray;
                scale = 0.8f;
                break;
            }
            case STAGE_2_SKY: {
                sprite = SpriteLibrary.spriteGemExplodeBlue;
                scale = 1.2f;
                break;
            }
            case STAGE_2_DAY: {
                sprite = SpriteLibrary.spriteGemExplodeRed;
                scale = 1.2f;
                break;
            }
            case STAGE_2_NIGHT: {
                sprite = SpriteLibrary.spriteGemExplodeWhite;
                scale = 1.2f;
                break;
            }
            default: {
                sprite = SpriteLibrary.spriteGemExplodeGray;
            }
        }
        EffectHandler.getInstance().registerFX(EntityFXFacingSprite.fromSpriteSheet(sprite, at.getX() + 0.5, at.getY() + (double)scale * 0.25, at.getZ() + 0.5, scale, 0));
    }

    @Override
    protected void onFirstTick() {
    }
}

