/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.tile.TileGrindstone;
import hellfirepvp.astralsorcery.common.util.BlockBreakAssist;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktPlayEffect
implements IMessage,
IMessageHandler<PktPlayEffect, IMessage> {
    private byte typeOrdinal;
    public int data = 0;
    public BlockPos pos;

    public PktPlayEffect() {
    }

    public PktPlayEffect(EffectType type, BlockPos pos) {
        this.typeOrdinal = (byte)type.ordinal();
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.typeOrdinal = buf.readByte();
        this.pos = ByteBufUtils.readPos(buf);
        this.data = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.typeOrdinal);
        ByteBufUtils.writePos(buf, this.pos);
        buf.writeInt(this.data);
    }

    public IMessage onMessage(PktPlayEffect message, MessageContext ctx) {
        try {
            EffectType type = EffectType.values()[message.typeOrdinal];
            EventAction trigger = type.getTrigger(ctx.side);
            if (trigger != null) {
                AstralSorcery.proxy.scheduleClientside(() -> trigger.trigger(message));
            }
        }
        catch (Exception exc) {
            AstralSorcery.log.warn("Error executing ParticleEventType " + message.typeOrdinal + " for pos " + this.pos.toString());
        }
        return null;
    }

    private static interface EventAction {
        public void trigger(PktPlayEffect var1);
    }

    public static enum EffectType {
        GRINDSTONE_WHEEL,
        BEAM_BREAK;


        @SideOnly(value=Side.CLIENT)
        private static EventAction getClientTrigger(EffectType type) {
            switch (type) {
                case GRINDSTONE_WHEEL: {
                    return TileGrindstone::playWheelAnimation;
                }
                case BEAM_BREAK: {
                    return BlockBreakAssist::blockBreakAnimation;
                }
            }
            return null;
        }

        public EventAction getTrigger(Side side) {
            if (!side.isClient()) {
                return null;
            }
            return EffectType.getClientTrigger(this);
        }
    }
}

