/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wearable;

import com.google.common.collect.Multimap;
import hellfirepvp.astralsorcery.client.models.base.ASCape;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeEffectFactory;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectOctans;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerCapeEffects;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.base.render.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.ItemComparator;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCape
extends ItemArmor
implements ItemDynamicColor {
    private static final UUID OCTANS_UNWAVERING = UUID.fromString("845DB25C-C624-495F-8C9F-60210A958B6B");
    private Object objASCape = null;

    public ItemCape() {
        super(RegistryItems.imbuedLeatherMaterial, -1, EntityEquipmentSlot.CHEST);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (IConstellation c : ConstellationRegistry.getAllConstellations()) {
                if (c instanceof IMinorConstellation) continue;
                ItemStack stack = new ItemStack((Item)this);
                ItemCape.setAttunedConstellation(stack, c);
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IConstellation cst;
        float perc;
        if (Mods.DRACONICEVOLUTION.isPresent() && (perc = Config.capeChaosResistance) > 0.0f) {
            int displayPerc = MathHelper.func_76141_d((float)(perc * 100.0f));
            String out = I18n.func_135052_a((String)"misc.chaos.resistance", (Object[])new Object[]{displayPerc + "%"});
            if (perc >= 1.0f) {
                out = I18n.func_135052_a((String)"misc.chaos.resistance.max", (Object[])new Object[0]);
            }
            tooltip.add(TextFormatting.DARK_PURPLE + out);
        }
        if ((cst = ItemCape.getAttunedConstellation(stack)) != null) {
            String n = cst.getUnlocalizedName();
            n = I18n.func_135052_a((String)n, (Object[])new Object[0]);
            tooltip.add(TextFormatting.BLUE + n);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        CapeEffectOctans ceo;
        super.onArmorTick(world, player, itemStack);
        if (!world.field_72995_K && (ceo = (CapeEffectOctans)ItemCape.getCapeEffect(player, Constellations.octans)) != null && player.func_70090_H()) {
            NBTTagCompound perm = NBTHelper.getPersistentData(itemStack);
            perm.func_74768_a("AS_UpdateAttributes", field_77697_d.nextInt());
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        EntityPlayer potentialCurrent;
        CapeEffectOctans ceo;
        IConstellation cst;
        Multimap out = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.CHEST && (cst = ItemCape.getAttunedConstellation(stack)) != null && cst.equals(Constellations.octans) && (ceo = (CapeEffectOctans)ItemCape.getCapeEffect(stack)) != null && (potentialCurrent = EventHandlerCapeEffects.currentPlayerInTick) != null && potentialCurrent.func_70090_H()) {
            out.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(OCTANS_UNWAVERING, OCTANS_UNWAVERING.toString(), 500.0, 0).func_111168_a(false));
        }
        return out;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (EventHandlerCapeEffects.inElytraCheck) {
            return;
        }
        super.setDamage(stack, damage);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.objASCape == null) {
            this.objASCape = new ASCape();
        }
        return (ModelBiped)this.objASCape;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "astralsorcery:textures/models/as_cape.png";
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ItemComparator.compare(repair, ItemCraftingComponent.MetaType.STARDUST.asStack(), ItemComparator.Clause.ITEM, ItemComparator.Clause.META_STRICT);
    }

    @Override
    public int getColorForItemStack(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return 0xFFFFFF;
        }
        IConstellation cst = ItemCape.getAttunedConstellation(stack);
        if (cst != null) {
            Color c = cst.getConstellationColor();
            return 0xFF000000 | c.getRGB();
        }
        return -16777216;
    }

    @Nullable
    public static CapeArmorEffect getCapeEffect(@Nullable EntityPlayer entity) {
        if (entity == null) {
            return null;
        }
        ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        IConstellation cst = ItemCape.getAttunedConstellation(stack);
        if (cst == null) {
            return null;
        }
        return ItemCape.getCapeEffect(stack);
    }

    @Nullable
    public static <V extends CapeArmorEffect> V getCapeEffect(@Nullable EntityPlayer entity, @Nonnull IConstellation expectedConstellation) {
        if (entity == null) {
            return null;
        }
        ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        IConstellation cst = ItemCape.getAttunedConstellation(stack);
        if (cst == null || !cst.equals(expectedConstellation)) {
            return null;
        }
        return ItemCape.getCapeEffect(stack);
    }

    @Nullable
    public static <V extends CapeArmorEffect> V getCapeEffect(@Nonnull ItemStack stack) {
        IConstellation cst = ItemCape.getAttunedConstellation(stack);
        if (cst == null) {
            return null;
        }
        CapeEffectFactory<? extends CapeArmorEffect> call = CapeEffectRegistry.getArmorEffect(cst);
        if (call == null) {
            return null;
        }
        try {
            NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
            return (V)call.deserializeCapeEffect(cmp);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Nullable
    public static IConstellation getAttunedConstellation(@Nonnull ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCape)) {
            return null;
        }
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        return IConstellation.readFromNBT(cmp);
    }

    public static void setAttunedConstellation(@Nonnull ItemStack stack, @Nonnull IConstellation cst) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCape)) {
            return;
        }
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        cst.writeToNBT(cmp);
    }
}

