/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.gem;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.GemAttributeModifier;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.base.IItemVariants;
import hellfirepvp.astralsorcery.common.item.gem.GemAttributeHelper;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPerkGem
extends Item
implements IItemVariants {
    public ItemPerkGem() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerProgress prog = ResearchManager.clientProgress;
        if (prog.wasOnceAttuned()) {
            for (GemAttributeModifier mod : ItemPerkGem.getModifiers(stack)) {
                tooltip.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + mod.getLocalizedDisplayString());
            }
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"progress.missing.knowledge", (Object[])new Object[0]));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (GemType type : GemType.values()) {
                items.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return RegistryItems.rarityRelic;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (ItemPerkGem.getModifiers(stack).isEmpty()) {
            GemAttributeHelper.rollGem(stack);
        }
    }

    @Nonnull
    public static List<GemAttributeModifier> getModifiers(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemPerkGem)) {
            return Lists.newArrayList();
        }
        ArrayList modifiers = Lists.newArrayList();
        NBTTagList mods = NBTHelper.getPersistentData(stack).func_150295_c("modifiers", 10);
        for (int i = 0; i < mods.func_74745_c(); ++i) {
            NBTTagCompound tag = mods.func_150305_b(i);
            modifiers.add(GemAttributeModifier.deserialize(tag));
        }
        return modifiers;
    }

    public static boolean setModifiers(ItemStack stack, List<GemAttributeModifier> modifiers) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemPerkGem)) {
            return false;
        }
        NBTTagList mods = new NBTTagList();
        for (GemAttributeModifier modifier : modifiers) {
            mods.func_74742_a((NBTBase)modifier.serialize());
        }
        NBTHelper.getPersistentData(stack).func_74782_a("modifiers", (NBTBase)mods);
        return true;
    }

    @Nullable
    public static GemType getGemType(ItemStack gem) {
        if (gem.func_190926_b() || !(gem.func_77973_b() instanceof ItemPerkGem)) {
            return null;
        }
        int meta = gem.func_77960_j();
        if (meta < 0 || meta >= GemType.values().length) {
            return null;
        }
        return GemType.values()[meta];
    }

    public String func_77667_c(ItemStack stack) {
        Item i = stack.func_77973_b();
        if (i instanceof ItemPerkGem) {
            GemType type = GemType.values()[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)GemType.values().length)];
            return super.func_77667_c(stack) + "." + type.name().toLowerCase();
        }
        return super.func_77667_c(stack);
    }

    @Override
    public String[] getVariants() {
        String[] sub = new String[GemType.values().length];
        GemType[] values = GemType.values();
        for (int i = 0; i < values.length; ++i) {
            GemType mt = values[i];
            sub[i] = mt.name().toLowerCase();
        }
        return sub;
    }

    @Override
    public int[] getVariantMetadatas() {
        int[] sub = new int[GemType.values().length];
        GemType[] values = GemType.values();
        for (int i = 0; i < values.length; ++i) {
            GemType mt = values[i];
            sub[i] = mt.ordinal();
        }
        return sub;
    }

    public static enum GemType {
        SKY(1.0f, 1.0f),
        DAY(7.5f, 0.6f),
        NIGHT(0.5f, 3.0f);

        public final float countModifier;
        public final float amplifierModifier;

        private GemType(float countModifier, float amplifierModifier) {
            this.countModifier = countModifier;
            this.amplifierModifier = amplifierModifier;
        }

        public ItemStack asStack() {
            return new ItemStack((Item)ItemsAS.perkGem, 1, this.ordinal());
        }
    }
}

