/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationCrafttweaker;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.BaseTweaker;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.LiquidInteractionAdd;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.LiquidInteractionRemove;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.astralsorcery.LiquidInteraction")
public class LiquidInteraction
extends BaseTweaker {
    protected static final String name = "AstralSorcery LiquidInteraction";

    @ZenMethod
    public static void removeInteraction(ILiquidStack liquid1, ILiquidStack liquid2) {
        LiquidInteraction.removeInteraction(liquid1, liquid2, null);
    }

    @ZenMethod
    public static void removeInteraction(ILiquidStack liquid1, ILiquidStack liquid2, IItemStack output) {
        FluidStack comp1 = LiquidInteraction.convertToFluidStack(liquid1, true);
        FluidStack comp2 = LiquidInteraction.convertToFluidStack(liquid2, true);
        ItemStack out = LiquidInteraction.convertToItemStack(output);
        ModIntegrationCrafttweaker.recipeModifications.add(new LiquidInteractionRemove(comp1, comp2, out));
    }

    @ZenMethod
    public static void addInteraction(ILiquidStack liquidIn1, float chanceConsumption1, ILiquidStack liquidIn2, float chanceConsumption2, int weight, IItemStack output) {
        ItemStack out = LiquidInteraction.convertToItemStack(output);
        if (out.func_190926_b()) {
            CraftTweakerAPI.logError((String)"[AstralSorcery LiquidInteraction] Skipping recipe-removal due to invalid/empty item output.");
            return;
        }
        FluidStack in1 = LiquidInteraction.convertToFluidStack(liquidIn1, false);
        if (in1 == null || in1.getFluid() == null) {
            CraftTweakerAPI.logError((String)"[AstralSorcery LiquidInteraction] Skipping recipe-removal due to invalid/empty fluid input.");
            return;
        }
        FluidStack in2 = LiquidInteraction.convertToFluidStack(liquidIn2, false);
        if (in2 == null || in2.getFluid() == null) {
            CraftTweakerAPI.logError((String)"[AstralSorcery LiquidInteraction] Skipping recipe-removal due to invalid/empty fluid input.");
            return;
        }
        weight = Math.max(0, weight);
        chanceConsumption1 = Math.max(0.0f, chanceConsumption1);
        chanceConsumption2 = Math.max(0.0f, chanceConsumption2);
        ModIntegrationCrafttweaker.recipeModifications.add(new LiquidInteractionAdd(in1, in2, chanceConsumption1, chanceConsumption2, out, weight));
    }
}

