/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidIngredient
extends Ingredient {
    private final List<FluidStack> fluidsIn;
    private IntList itemIds = null;
    private ItemStack[] itemArray = null;
    private int cacheItemStacks = -1;
    private int cacheItemIds = -1;

    public FluidIngredient(FluidStack ... fluids) {
        super(0);
        this.fluidsIn = Arrays.asList(fluids);
    }

    public FluidIngredient(Fluid ... fluids) {
        super(0);
        this.fluidsIn = new ArrayList<FluidStack>(fluids.length);
        for (Fluid f : fluids) {
            this.fluidsIn.add(new FluidStack(f, 1000));
        }
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.itemArray == null || this.cacheItemStacks != this.fluidsIn.size()) {
            NonNullList lst = NonNullList.func_191196_a();
            for (FluidStack fluid : this.fluidsIn) {
                lst.add((Object)FluidUtil.getFilledBucket((FluidStack)fluid));
            }
            this.itemArray = (ItemStack[])lst.toArray((Object[])new ItemStack[lst.size()]);
            this.cacheItemStacks = this.fluidsIn.size();
        }
        return this.itemArray;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.itemIds == null || this.cacheItemIds != this.fluidsIn.size()) {
            this.itemIds = new IntArrayList(this.fluidsIn.size());
            for (FluidStack fluid : this.fluidsIn) {
                ItemStack bucketFluid = FluidUtil.getFilledBucket((FluidStack)fluid);
                this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)bucketFluid));
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
            this.cacheItemIds = this.fluidsIn.size();
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        FluidStack contained = FluidUtil.getFluidContained((ItemStack)input);
        if (contained == null || contained.amount <= 0) {
            return false;
        }
        for (FluidStack target : this.fluidsIn) {
            if (!contained.containsFluid(target)) continue;
            return true;
        }
        return false;
    }

    protected void invalidate() {
        this.itemIds = null;
        this.itemArray = null;
    }

    public boolean isSimple() {
        return false;
    }
}

